//
// File: NewModel1Clean.cpp
//
// MATLAB Coder version            : 3.2
// C/C++ source code generated on  : 23-Nov-2018 14:11:15
//

// Include Files
#include <Rcpp.h>
#include "include/rt_nonfinite.h"
#include "include/NewModel1Clean.h"
#include "include/repmat.h"
#include "include/bsxfun.h"

// Function Declarations
static void mapminmax_apply( double *x, double *settings_xoffset, 
                             double *settings_gain, double *y, int cpgs, int samples);
static void mapminmax_reverse(const double y[], double x[], int sizeobs);
static void tansig_apply(const double n[], double a[], int sizeobs5);

// Function Definitions

//
// Arguments    : const double x[1059]
//                const double settings_xoffset[353]
//                const double settings_gain[353]
//                double y[1059]
// Return Type  : void
//
static void mapminmax_apply( double *x, double *settings_xoffset, 
                             double *settings_gain, double *y, int cpgs, int samples)
{
  
  unsigned int isize = cpgs*samples;
  double b_y[isize];
  
  
  //  ===== MODULE FUNCTIONS ========
  //  Map Minimum and Maximum Input Processing Function
  bsxfun(x, settings_xoffset, y, cpgs, samples);
  memcpy(&b_y[0], &y[0], isize* sizeof(double));
  
  b_bsxfun(b_y, settings_gain, y, cpgs, samples);
  memcpy(&b_y[0], &y[0], isize* sizeof(double));
  
  c_bsxfun(b_y, y, cpgs, samples);
}

//
// Arguments    : const double y[3]
//                double x[3]
// Return Type  : void
//
static void mapminmax_reverse(const double y[], double x[], int sizeobs)
{
  int ak;
  double a[sizeobs];
  int ck;
  double b_x;
  
  //  Map Minimum and Maximum Output Reverse-Processing Function
  ak = 0;
  for (ck = 0; ck < sizeobs; ck++) {
    b_x = y[ak] - -1.0;
    ak++;
    a[ck] = b_x;
  }
  
  ak = 0;
  for (ck = 0; ck < sizeobs; ck++) {
    x[ck] = a[ak] / 0.0277777777777778;
    ak++;
  }
  
  for (ak = 0; ak < sizeobs; ak++) {
    a[ak] = x[ak];
  }
  
  ak = 0;
  for (ck = 0; ck < sizeobs; ck++) {
    x[ck] = a[ak] + 16.0;
    ak++;
  }
}

//
// Arguments    : const double n[15]
//                double a[15]
// Return Type  : void
//
static void tansig_apply(const double n[], double a[], int sizeobs5)
{
  int k;
  
  //  Sigmoid Symmetric Transfer Function
  for (k = 0; k < sizeobs5; k++) {
    a[k] = 2.0 / (1.0 + std::exp(-2.0 * n[k])) - 1.0;
  }
}

//
// RED3 neural network simulation function.
//
//  Generated by Neural Network Toolbox function genFunction, 18-Oct-2018 13:25:19.
//
//  [y1] = Red3(x1) takes these arguments:x
//    x = 431xQ matrix, input #1
//  and returns:
//    y = 1xQ matrix, output #1
//  where Q is the number of samples.
// Arguments    : const emxArray_real_T *x11
//                double b_y1[3]
// Return Type  : void
//
void NewModel1Clean( Rcpp::NumericMatrix x1, double b_y1[], int cpgs, int samples)
{
  
  const int sizealloc = cpgs * samples;
  const int inobs = samples;
  const int sizeobs5 = samples*5;
  
  double t0_xoffset[353] = { 0.3301587, 0.2921687, 0.03137724, 0.08788598,
                             0.03973289, 0.2988361, 0.3254237, 0.01646124, 0.3322259, 0.02059573,
                             0.03078112, 0.302465, 0.02380256, 0.03755031, 0.009516819, 0.3925234,
                             0.08772635, 0.09417877, 0.008193696, 0.1128501, 0.3253012, 0.233951,
                             0.03351561, 0.03718096, 0.3139932, 0.03587162, 0.3039216, 0.05295911,
                             0.02093979, 0.108816, 0.02135937, 0.3366667, 0.0652559, 0.03942285, 0.185018,
                             0.1519473, 0.0169566, 0.02158602, 0.3858696, 0.287234, 0.3224638, 0.01711804,
                             0.1193791, 0.004953765, 0.01860587, 0.04139621, 0.01543606, 0.02913919,
                             0.07258572, 0.2770311, 0.02773917, 0.2871622, 0.01994335, 0.3102493,
                             0.104277, 0.2611296, 0.2625091, 0.02501982, 0.3278688, 0.3076923, 0.03374233,
                             0.02373697, 0.02074319, 0.03234917, 0.01810614, 0.02448688, 0.335849,
                             0.01869315, 0.01232731, 0.3582554, 0.01499534, 0.3218391, 0.0156952,
                             0.07068904, 0.3548387, 0.33125, 0.04737146, 0.0304503, 0.02270205,
                             0.01433031, 0.09401137, 0.02504223, 0.05602568, 0.290625, 0.03551017,
                             0.2877698, 0.03082496, 0.2884615, 0.07735983, 0.03633572, 0.02804784,
                             0.06325823, 0.3209798, 0.1079527, 0.2919708, 0.2831541, 0.05626051,
                             0.0149634, 0.01893968, 0.01792323, 0.3323615, 0.2651007, 0.04558315,
                             0.02951237, 0.0158143, 0.01992694, 0.3107049, 0.006782428, 0.176893,
                             0.3571429, 0.01251949, 0.03029362, 0.2682996, 0.0223905, 0.04987399,
                             0.3018868, 0.0169055, 0.01918483, 0.1851909, 0.039081, 0.03098194,
                             0.02300841, 0.0771556, 0.3271028, 0.07211151, 0.04064609, 0.3585526,
                             0.1136964, 0.020682, 0.01476604, 0.0160975, 0.3184932, 0.3407407, 0.02259698,
                             0.02343622, 0.3322369, 0.2880435, 0.00539811, 0.01658918, 0.009612962,
                             0.2224712, 0.04390296, 0.2678571, 0.3322148, 0.07735962, 0.02666313,
                             0.01327836, 0.07289455, 0.2985612, 0.03891851, 0.02432862, 0.06889902,
                             0.01556068, 0.1575748, 0.009545057, 0.1251771, 0.4018127, 0.04985005,
                             0.2926829, 0.3057554, 0.01113229, 0.06495624, 0.01980482, 0.04670225,
                             0.3261649, 0.2722222, 0.03549627, 0.1321748, 0.01944581, 0.3071161,
                             0.01558006, 0.0336441, 0.05124249, 0.01773632, 0.02868479, 0.01448407,
                             0.2741117, 0.03300527, 0.02873674, 0.02829753, 0.05341246, 0.03087248,
                             0.07135608, 0.2525519, 0.03872679, 0.04123649, 0.01339014, 0.01806177,
                             0.148394, 0.02203199, 0.4093264, 0.02327785, 0.02956989, 0.3454545,
                             0.3184027, 0.114741, 0.3154122, 0.03165138, 0.03982874, 0.04330384,
                             0.05571333, 0.3103448, 0.05739245, 0.05732416, 0.362776, 0.3093093,
                             0.2028104, 0.007885076, 0.1433673, 0.03282252, 0.02143528, 0.3244147,
                             0.02427921, 0.1542283, 0.1410338, 0.2940969, 0.03173636, 0.02142769,
                             0.02144139, 0.02613497, 0.02951062, 0.2222222, 0.08598156, 0.07377432,
                             0.108226, 0.301314, 0.1180365, 0.02448005, 0.01619095, 0.05194205, 0.1185102,
                             0.03508048, 0.03219265, 0.01585555, 0.06191493, 0.02264894, 0.1802662,
                             0.1901108, 0.06932516, 0.07545859, 0.0213573, 0.09190672, 0.3454106,
                             0.03650123, 0.02729529, 0.0782213, 0.3011152, 0.0163624, 0.1283383, 0.020722,
                             0.2960289, 0.1936561, 0.3197026, 0.05016474, 0.3376623, 0.06389088,
                             0.01147767, 0.05840041, 0.08320414, 0.1723214, 0.03280142, 0.01723958,
                             0.2985075, 0.03631674, 0.1504975, 0.02364407, 0.06375, 0.05148086, 0.1934122,
                             0.03458712, 0.1588185, 0.0361777, 0.07984657, 0.1082474, 0.1058548,
                             0.02851972, 0.0593648, 0.1454836, 0.2241634, 0.1478514, 0.03960261,
                             0.02027613, 0.02237575, 0.03331082, 0.1396491, 0.2827869, 0.0195819,
                             0.07939067, 0.01043994, 0.01841319, 0.1965919, 0.02657807, 0.04914878,
                             0.1010722, 0.08114529, 0.01969271, 0.2607575, 0.03978389, 0.03860562,
                             0.3366609, 0.3706897, 0.04162416, 0.01664126, 0.02834231, 0.2873563,
                             0.3068182, 0.03995722, 0.07698864, 0.1071887, 0.1148351, 0.3203593,
                             0.04112482, 0.0918464, 0.02932347, 0.02229496, 0.3198529, 0.02176636,
                             0.03526551, 0.09284727, 0.3110236, 0.2993197, 0.2992701, 0.03931951,
                             0.01661165, 0.1500621, 0.02298646, 0.1039268, 0.01397103, 0.02025029,
                             0.2842466, 0.03397778, 0.07161858, 0.3201439, 0.3512545, 0.1159236,
                             0.03880166, 0.02566935, 0.3441108, 0.04072542, 0.05287174, 0.3490732,
                             0.05088809, 0.02941176, 0.01583464, 0.03867989, 0.02093707, 0.2726885,
                             0.04031978, 0.04059977, 0.04371536, 0.1257261, 0.02914785, 0.04608038 };
  
  double t0_gain[353] = { 3.51226200912626, 3.0549481300357, 6.43827197295308,
                          5.28196697914959, 7.25553271554165, 3.7082483680926, 3.43982752704779,
                          7.05370934118496, 4.33160610539881, 5.58868762441292, 6.31318751006559,
                          3.90844621088842, 6.0465333954272, 6.3842815922743, 5.9502420351689,
                          3.7100499502575, 7.62146180780693, 6.15224221697525, 6.53838990788533,
                          2.75862906066749, 3.49394534211665, 4.78880989214882, 6.7208684544916,
                          4.9572162494376, 5.6004948597258, 6.04454990437824, 3.1294893502695,
                          6.54992323653715, 5.09458465774491, 2.73965021789808, 5.58202006775289,
                          3.31142878383307, 7.10101189419492, 5.13523579269618, 8.04445041521431,
                          7.00072247455937, 3.93193119356327, 5.96024137547113, 3.80195610641675,
                          3.27950517514115, 3.21101919033509, 6.96306677970973, 9.75870622976288,
                          5.71194161504607, 3.75007314986438, 5.98823210591242, 6.53839982602626,
                          5.56776892066377, 6.48290904206332, 4.56870197009282, 5.27330303592229,
                          3.21176482301731, 6.33747799112721, 3.92769197625553, 2.46243645528825,
                          2.74153318598506, 4.80414463165662, 6.28755477874912, 3.22835320573052,
                          3.12133828003024, 5.95193685994917, 7.13063497983617, 6.21892268296389,
                          6.93814398334734, 4.8956928575464, 5.39384042840901, 3.59817133736293,
                          5.57712897487211, 4.91802766729907, 3.61396102053922, 5.51839742648432,
                          3.20847550890432, 7.0285700831023, 7.90678345091247, 3.54115172418677,
                          3.51624425731383, 7.38152177748225, 6.99462358258325, 5.79418672143332,
                          6.07450212849036, 4.85998705348049, 5.22534332269183, 5.86380916209627,
                          2.97580920063664, 6.78845079508542, 2.97057246941759, 5.62332379261474,
                          3.08207155892104, 5.5705175013544, 6.78398713104777, 5.8284694270259,
                          6.88009477468154, 4.52483876302673, 3.84038366969014, 3.14174895823532,
                          3.27281623382308, 8.09355207344866, 6.18150314993947, 4.97175521006387,
                          4.50286085887523, 4.3970008057504, 4.90434684521759, 6.84843673302859,
                          6.34754933656525, 6.14158000129587, 6.12184566545473, 3.28973015330472,
                          6.29433826287443, 4.24341321487987, 3.84333933919161, 6.36780823320035,
                          6.92502839607894, 3.44539895394242, 6.49653539767242, 6.8541808326877,
                          4.22356869592248, 5.4727438203145, 5.26788415722559, 4.01680389742449,
                          5.84565426754683, 5.83396602694896, 5.43611667308899, 3.86721305230812,
                          3.14587385612094, 4.08753881296933, 6.85704074601038, 3.52466818333139,
                          10.7119195277757, 6.16426470955372, 17.3255035917501, 5.9867549034516,
                          3.55012150290844, 3.36047872035659, 5.4224006746334, 6.01321319414429,
                          3.56461442902452, 6.17611246453754, 6.84200934898999, 6.21717100565103,
                          30.9569786533677, 4.8680194730515, 6.88438203583844, 2.85951543795195,
                          3.35180962525763, 7.22703454392425, 12.0639725925845, 5.48899930437912,
                          3.98868450093929, 3.04321687500276, 6.18024263570785, 6.45180271109911,
                          4.9086755637393, 5.92184257421076, 8.24084699425407, 6.0242153637956,
                          2.56923741565033, 5.78220013293278, 6.40839859085723, 3.6225538026219,
                          3.50211177339936, 5.7273291336547, 7.28464866649407, 6.92336472202275,
                          7.48597269079733, 3.31090635730441, 3.04376199242225, 7.01603651959265,
                          5.5882046411716, 5.75097215152121, 3.10031230996054, 5.67067273232066,
                          6.05527924979934, 5.93230627512536, 5.42753831991311, 6.56494266129843,
                          4.8602929449227, 3.80328135705643, 6.23361863462994, 5.70313266804009,
                          5.75809710092191, 6.43047448156229, 6.51441565268158, 3.8785259631049,
                          5.18936916212186, 6.95513772720218, 6.63084441383352, 5.9293647818145,
                          7.05525282445582, 7.14388024856417, 5.89947686683857, 3.71676054584345,
                          6.68938269540314, 5.87055468023955, 4.51903564683104, 4.80054342151532,
                          5.67843048181483, 3.26996522228488, 6.8701320391287, 6.73988745601128,
                          6.2435114307456, 5.01762730103057, 3.51672033474958, 7.39008040592234,
                          7.14578844736094, 3.7023393231013, 6.32231143706139, 2.79899062799973,
                          5.72642862254104, 6.34045651920984, 6.4706223392801, 6.81121843093912,
                          3.99012444200604, 6.50484583369015, 3.37738741183541, 6.24015810064564,
                          6.00831370367177, 4.79440925854125, 5.33087530227062, 6.31738258457451,
                          5.7260596381136, 5.49627547640479, 2.82986177681644, 5.05595117811752,
                          5.5264621098297, 3.18187350302795, 3.58892264669407, 7.61589391364414,
                          3.45484751814551, 5.485116752767, 6.3024074723864, 2.73059201009664,
                          6.67943507475557, 5.84061572939142, 6.12172967635486, 6.41818719137144,
                          5.93283156608124, 6.11514013913778, 4.75755612905252, 3.32515821019635,
                          6.86073607945501, 6.02791648683383, 3.62939993969389, 4.68472393507441,
                          6.94486475344671, 6.59762232907218, 2.90620752850154, 3.16912009380595,
                          5.96742917482091, 4.91775545772501, 4.22262613987154, 2.96420046176315,
                          3.79604819994241, 4.24984679302311, 6.93660319258549, 4.04048893148462,
                          6.65895293558608, 6.36034745687708, 6.18703933431911, 4.70288954469116,
                          3.36779598969589, 6.60758429097053, 5.44719392162882, 2.99917657607104,
                          6.33800397747778, 5.51526501262031, 6.95164881465872, 6.33376202345962,
                          5.65832744254294, 4.35769721848187, 5.01430732308496, 6.75255466024184,
                          6.73048059669749, 6.86759816707926, 7.26378093598902, 8.71623765344936,
                          5.66649803168524, 6.32006982413142, 4.81001290766964, 6.41007150434763,
                          4.47032464391629, 6.15658934062282, 6.96371386280794, 5.76914450942584,
                          7.48215468696386, 5.0912569626121, 6.27312430446734, 5.98821220427588,
                          6.27127471152685, 5.65742599676633, 6.67181263575262, 4.65700679271011,
                          6.05858965181376, 6.37640993582399, 3.87819294048661, 7.5686072487352,
                          6.01744113189993, 4.12747116858202, 6.28764511374051, 6.83123848850924,
                          4.82337058100875, 4.72478036267887, 5.96002894666859, 5.62499233594794,
                          7.06523069620889, 2.90001754510615, 3.09274986751433, 3.38101191252213,
                          5.97106255894185, 6.67860578761299, 8.24529760371038, 4.32691392383593,
                          6.17463319900213, 7.61074972734489, 6.19292388466138, 5.9771534069894,
                          3.32639004850542, 5.76705692148619, 5.89279375849428, 3.78982947340149,
                          3.12686977040802, 3.34296329626879, 2.96573141832101, 6.3270678384101,
                          7.09627642409406, 6.61509975901192, 6.33032109224373, 2.68454574130375,
                          6.84878334959406, 6.26343487206825, 4.61127525970126, 6.08172401793233,
                          5.47066421960209, 3.64499564878644, 4.2818355543928, 2.98553983635659,
                          6.68163709730441, 5.62738521998223, 3.49292203012121, 4.49975969033374,
                          6.19741570244174, 3.59877929406345, 7.33759938915953, 5.82108533321086,
                          6.18818276154215, 6.78763568356463, 5.90772086834163, 3.65432831435702,
                          7.82138705103674, 7.2142334806588, 4.08595342372661, 3.77191245391194,
                          3.0392192245812, 4.51180753567509 };
  
  double xp1[sizealloc];
  double dv1[sizeobs5];
  double dv2[sizeobs5];
  int i0;
  int i1;
  double dv3[samples];
  double d0;
  int i2;
  
  static const double a[1765] = { 0.046465863584370819, -0.024806425885406602,
                                  0.082740500346220935, 0.0083528170555940712, 0.0064795001975091948,
                                  -0.03775606616772726, 0.013446026263179301, -0.047401799192415814,
                                  -0.0030490497947388896, -0.0021519951683959082, 0.008478648752766051,
                                  -0.00037460077751817983, -0.0072204697844232479, -0.00094962935246172074,
                                  -0.00094117861798776749, -0.047066224350049354, 0.017428906478319229,
                                  -0.013443944413538349, -0.0056922845143780286, -0.00459909456321877,
                                  -0.023228117582920833, 0.0082041989487593968, -0.013613629225216372,
                                  -0.0032509947857977234, -0.0027906898349535714, 0.015086170869457015,
                                  -0.0071727384757353822, -0.058836846862657242, 0.0018697854596828386,
                                  0.00141258586117522, -0.025775214866338471, 0.0077474512696186519,
                                  -0.027954295665416042, -0.0012513028785425858, -0.00077323865786607681,
                                  0.010921150851980994, -0.0038166232042433266, 0.0085557592278151691,
                                  6.0907891349311612E-5, -0.00022135395022107102, 0.014361277425788259,
                                  -0.0057984765417862507, 0.022988700042565337, 0.002227603690065731,
                                  0.0019256084916558988, 0.027530048302997583, -0.010243732439553427,
                                  0.023397569031620196, 0.0020736120116757106, 0.0013543142130229213,
                                  -0.0017312246932520688, 0.0010418261946386095, -0.010910319568422136,
                                  -0.0013631187923741222, -0.0012792727070524671, -0.015887648021268509,
                                  0.010657907454322588, -0.023382510636280832, -0.0037187305218329579,
                                  -0.0027452972717552423, -0.017523521405670657, 0.0084948282280562486,
                                  -0.039801799525782257, -0.0035095445456332359, -0.0028739507203886729,
                                  -0.0052044710025714253, 0.0040584998262894537, -0.0030636271061322265,
                                  -0.0021343101341409348, -0.0019209984676846598, -7.22906381934658E-5,
                                  0.00067448832870075129, -0.00752356780164022, -0.001286521217121838,
                                  -0.0012892555378532194, -0.0037220431573732394, -0.0014821665693052373,
                                  -0.0006517061787490499, 0.0014697246096523767, 0.0013091069658327855,
                                  0.024258312383291646, -0.0093114704235477616, 0.036075925026779553,
                                  0.0029129871902063781, 0.0020568653021037315, -0.0038300950301341161,
                                  0.0064242983246968876, 0.017837044391495582, -0.002899255810529773,
                                  -0.0023715859577225053, -0.01627748284732173, 0.00823206408022726,
                                  -0.037633542195120211, -0.0036683715397706576, -0.003107101519905587,
                                  0.0025989267953093992, 4.9936508818850474E-5, -0.0043517862017274922,
                                  0.00021317719713429611, 0.00037549477968272944, 0.0087900239493571928,
                                  -0.0061730045659237395, 0.0017718867104890045, 0.0029577160298551518,
                                  0.0025075362017728856, -0.013525512111166633, 0.0027555514662646729,
                                  0.025671733464799892, -0.0012229337070291764, -0.0010025279908247992,
                                  0.0222754784651458, -0.0083833115943224411, 0.031704304007384,
                                  0.0015440665733527129, 0.00095501348087939219, 0.03040867839118435,
                                  -0.011837476861773839, 0.020268167850365417, 0.002658062380944474,
                                  0.0018230536342242322, -0.0015285478456275041, -0.006180823820954362,
                                  -0.0068318830121314872, 0.0022761570188471959, 0.0017981552145317074,
                                  0.054416645633170183, -0.020383041445036432, 0.072397699720363931,
                                  0.0051138034868946514, 0.0037298401384878144, 0.019803434196017877,
                                  -0.00961089974369322, 0.037009655148393016, 0.0039290561540642329,
                                  0.0032924389855014183, 0.0023893434109119854, -2.5032858341478406E-5,
                                  0.00745396994042328, -0.0008714334624535722, -0.00087808758112815769,
                                  0.0030997249991144911, 0.00072315993981654936, 0.00028775317942426637,
                                  -0.0013687811742731581, -0.0013077927315254892, -0.035319086925343655,
                                  0.012115230192871434, -0.0075504846008617871, -0.0040894891111776729,
                                  -0.003550377890529506, -0.066908072405309008, 0.0295351174187288,
                                  -0.10455635244342197, -0.010046896812436966, -0.0079092664091165565,
                                  -0.030256948314197511, 0.011700030593684638, -0.046133292807247907,
                                  -0.0026129743572195756, -0.0017698651928064093, -0.043083309717673934,
                                  0.021012030503870419, -0.066818382334360091, -0.007427531926143152,
                                  -0.0058388940778129261, -0.052379971805505576, 0.023278136189126268,
                                  -0.0874115160043595, -0.00821070098529227, -0.0064733446199544608,
                                  -0.011997705069017161, 0.0070227732578375486, 0.019468326692347718,
                                  -0.002792133233392508, -0.00222117662203238, -0.024874151655485979,
                                  0.014414270430328576, 0.03523664766318238, -0.00517082603698388,
                                  -0.0038788313052838244, -0.03123952079147058, 0.00996719080708424,
                                  -0.0237862598135537, -0.0026453213203212686, -0.0019862896111015362,
                                  0.011836037768980337, -0.0036858193358418386, -0.0018334576772644055,
                                  3.3388909098838261E-5, -0.00014000195989236753, -0.02367635179974038,
                                  0.00881706294751566, -0.03004132162579758, -0.0018094528594078351,
                                  -0.0011711060740413, -0.022566256845280734, 0.0088406068973280582,
                                  -0.039153396233766971, -0.0017330163823125807, -0.001088977296612587,
                                  0.018551803815007074, -0.0064589724011465052, -0.016482975878564888,
                                  0.002792178722277076, 0.0026013808643036108, -0.044996221371786951,
                                  0.017718506497499786, -0.062333210901705335, -0.0063809552388959185,
                                  -0.0052905700795757276, -0.014577386742084858, 0.0057499136309316322,
                                  -0.0073467825913208279, -0.001975873076981122, -0.001565854782226194,
                                  0.017515356988440148, -0.0062046412817020925, 0.0268696154282043,
                                  0.00078295738642532959, 0.00028791677662455122, -0.0081054419434507651,
                                  0.0038235740199006538, -0.0027907775640687504, -0.0021097073362103379,
                                  -0.0019193269926316536, -0.054056148876937382, 0.023984366742298511,
                                  -0.08098732212526065, -0.0084554453371680841, -0.0066760018528662065,
                                  0.034693352548844848, -0.013764945453477402, 0.037078459766615481,
                                  0.0031044746487026236, 0.0021349458441590964, -0.01219816695166692,
                                  0.0081433107488034, -0.02437724114933475, -0.0035733021302071129,
                                  -0.0029364555777625814, -0.045885780851834965, 0.027461518415062176,
                                  -0.080079738887066348, -0.0093360850122840219, -0.00728681995918342,
                                  -0.025517306003230933, 0.011505856689813661, -0.018075701380040447,
                                  -0.0031433037366170678, -0.0021879843281756425, -0.0095807088175317526,
                                  0.0046332752238591119, -0.0165300053282359, -0.0024372107778602185,
                                  -0.0021596589214739276, -0.01590231941183793, 0.0058888843553670548,
                                  -0.02916806162947741, -0.00069196352151354955, -0.00028089232681366807,
                                  0.0090450935439030725, -0.0029390220244092762, 0.012810582609251407,
                                  -0.00016615849733861708, -0.00038155002189666122, -0.0019849462748723636,
                                  0.00046118408596573405, 0.006565828618222593, 0.0003580704961373539,
                                  0.00045023295231824949, -0.041695327237809776, 0.02143773521227724,
                                  -0.0017750228202172218, -0.0074541645214099761, -0.0058683235643694114,
                                  -0.027498923434329445, 0.010367486234463836, -0.039373417497352944,
                                  -0.0020430469214784345, -0.0012560689506100025, 0.020225330702857886,
                                  -0.0075713933050744241, 0.042186154468754331, 0.0022158052911496265,
                                  0.0016197849670741816, -0.0034992413614966206, 0.0024548477195379791,
                                  -0.016466733531726275, -0.0018026565663036944, -0.0016596390773288075,
                                  -0.0043997756945008352, 0.0013992213006948288, -0.0052409693992336746,
                                  0.00061038681243957707, 0.00076960708103810294, -0.023349408218072507,
                                  0.0084822725696471722, -0.043379924166295013, -0.0016083906481275511,
                                  -0.00099030791854167019, -0.026596290561129589, 0.01310904251923452,
                                  -0.042164261250721508, -0.0051687975487852717, -0.0042357988530164689,
                                  0.012501964961631109, -0.0031986933658512541, 0.0008815684610985336,
                                  0.0001105599437367426, -6.8815659601776286E-5, 0.01107624838307828,
                                  -0.0035481757190830967, -0.0068535028897366785, 0.00018735088784919998,
                                  -2.5520135765890165E-5, -0.013319362043615729, 0.00570772866975203,
                                  -0.016833919148387135, -0.0027096736529100838, -0.0023651824495759619,
                                  0.062962125286733742, -0.022615883146665464, 0.0442716095203677,
                                  0.0064030425553990074, 0.0048857320534809014, 0.041786787518389566,
                                  -0.01575327845238968, 0.047827598971773556, 0.0036891231809846187,
                                  0.002618633249440369, -0.03742639066335595, 0.01662055868661878,
                                  -0.062101414492273577, -0.0050030938248347857, -0.0037393659380171853,
                                  0.018863909110037217, -0.0077064444093448807, 0.019217052772508687,
                                  0.0013441078861215251, 0.00077297385916732673, 0.01142017079974772,
                                  -0.0032364448037767342, -0.00014709853172460783, -0.00010769726647599087,
                                  -0.00033729595097287037, -0.00796010118967782, 0.00600074110658973,
                                  -0.0069942803831366668, -0.0010692123148480258, -0.00053631655244500414,
                                  -0.0064252530823548223, 0.0030898665420171787, -0.0048146193837714547,
                                  -0.0020075836885310575, -0.0018464167094102472, -0.025608920789532457,
                                  0.00964264235678191, -0.039500843203242576, -0.0017665713364900383,
                                  -0.001068343620904011, -0.0029069316363959882, 0.0024199620427959442,
                                  -0.00962810609757326, -0.001795110715172776, -0.0016356991490273987,
                                  -0.016523805648296964, 0.0036317758369091616, 0.045085644986440222,
                                  -0.0016440934177669284, -0.0018074969811374836, 0.013986835060663227,
                                  -0.0068633441451637286, 0.012011784308696176, 0.0031660282363552617,
                                  0.00272000219286631, 0.01060909911405244, -0.0064000209212492715,
                                  0.016462596352057154, 0.0029911750731081528, 0.0025051389191165078,
                                  0.017824599229437795, -0.0073212695305486528, 0.012119408033058766,
                                  0.0015102004455002521, 0.00089702864610546732, -0.026796688702115382,
                                  0.013813014379217562, -0.0198346736053994, -0.0054935425045362528,
                                  -0.0043666088799706486, -0.021077434023326926, 0.010199500428416625,
                                  -0.03199501422831811, -0.004188377699672929, -0.003501983251115648,
                                  0.017659913871611151, -0.0071206976447715543, 0.011682808965609305,
                                  0.0011921023543680709, 0.000657209864054462, -0.00040569234039290156,
                                  0.0022369927258528766, -0.024495837454166045, -0.0016749079758476631,
                                  -0.0013893811759258137, -0.067536743763466939, 0.029942273940238739,
                                  -0.11720616395865412, -0.010106713044273484, -0.00799361294038412,
                                  0.056777789772355931, -0.022265552483380181, 0.0262537525363384,
                                  0.0059801194900922774, 0.0045389504663916232, -0.026751215641821528,
                                  0.0094871645922443276, -0.031127645446806428, -0.0017948900599881841,
                                  -0.0011445843403300108, -0.0532053378414375, 0.023403931785004183,
                                  -0.10507479251459026, -0.00787367808851394, -0.0062271655030719285,
                                  0.036657025791525709, -0.014004642765402841, 0.038059902651367432,
                                  0.0052510522582252016, 0.00441459517846202, 0.015843583057061846,
                                  -0.0053729160652162336, 0.014368831809161769, 0.00061603828318699779,
                                  0.00017338098192719832, 0.022814801211471249, -0.0092410787753102169,
                                  0.023023113003911889, 0.0038065125543976295, 0.0033073517044269521,
                                  -0.019891321194540307, 0.0097645028330533325, -0.010144393733852895,
                                  -0.0039667299152113646, -0.0031167887209898994, 0.030117847556982987,
                                  -0.012294174429043569, 0.010418692349515153, 0.0029323204164373078,
                                  0.0020490221423692346, -0.037527031062147491, 0.017868269862735531,
                                  -0.070901772339745248, -0.0065145729499798688, -0.0052111300338545906,
                                  -0.040806320345756278, 0.015590998710179658, -0.053027331595289086,
                                  -0.0051393669764477554, -0.0039404711605860419, -0.065369889461991834,
                                  0.027600516485997297, -0.0017615539221055112, -0.0093925011470894649,
                                  -0.0073862299914362033, -0.033156867244482614, 0.017132235508904931,
                                  -0.092070344071852522, -0.00590521282709461, -0.0042989061656297147,
                                  0.0039202596773321545, -0.0024115997120014708, -0.01820486803842368,
                                  0.0016763306029961953, 0.0016287900469984901, 0.031573292873291886,
                                  -0.012763063385326824, 0.031007089599262804, 0.0048738575060905415,
                                  0.0040798086687631, -0.014412530135842356, 0.00709415357474259,
                                  -0.021383157847695764, -0.0030008449339432005, -0.002445013079339409,
                                  -0.00032859752956267797, 0.0010453309528765773, -0.0026364285439954421,
                                  -0.0014100383128295378, -0.0013745173489325719, -0.0077738914206593223,
                                  0.0029472040770680955, -0.013936399686677451, -0.0018933718542168403,
                                  -0.0018160831741998614, 0.019406811959798039, -0.0066273622803285654,
                                  0.020128285943258422, 0.0009218295995906048, 0.0004699924469729456,
                                  -0.015112152430883891, 0.0025763229038091914, 0.022859103510342729,
                                  0.00012812470732884664, 0.00013322189120469648, -0.0077441704874192706,
                                  0.0035434945659406406, 0.054018959479700791, -0.0016344594805091338,
                                  -0.0013299106558598843, 0.011975882096103313, -0.0048273008033776505,
                                  0.0065948159587346936, 0.000614121347998777, 0.00026218315394099497,
                                  -0.017430588756102469, 0.00784761593955023, -0.032096982184698246,
                                  -0.0033610810828417197, -0.0028494621707770974, -0.029296978155181896,
                                  0.012567566687307279, -0.047198949656808049, -0.0048898980584392926,
                                  -0.0040754035428969956, -0.012151241706761545, 0.0054454205552838626,
                                  -0.027275805387238006, -0.0026879586043955447, -0.0023362460493485189,
                                  -0.033042016132566271, 0.013533637757615829, -0.064410216636270459,
                                  -0.0032441296940555397, -0.0021780304197347774, -0.0043494346902625885,
                                  0.0024723262305098195, -0.015475270654936155, -0.001801789068412708,
                                  -0.0016543406046389706, -0.015904626920550544, 0.0090813280627413569,
                                  -0.085182915354022851, -0.0031008232420787277, -0.0020766584137467546,
                                  -0.016000918710348026, 0.0046614938811911141, -0.023641002958142313,
                                  -0.00057566059363064136, -0.0001708030331888755, 0.014299994580098924,
                                  -0.005043156167949342, 0.022107433375435685, 0.00047402000048913333,
                                  9.4919606961047358E-5, -0.007189156038651663, 0.0049682579836814291,
                                  -0.005156664416375161, -0.0025657777619226218, -0.0021983416947794457,
                                  -0.044412673046103343, 0.016660464544457153, -0.016680598461562859,
                                  -0.00609907513539969, -0.0049323563093123151, -0.024448135420175956,
                                  0.01390891304247987, -0.059538824168630433, -0.0053754008669329376,
                                  -0.0042901618833201165, -0.034195422564928253, 0.016535374601406094,
                                  -0.017783206630358702, -0.0060211768979729248, -0.0048109947031955867,
                                  -0.021754140722819486, 0.0090697698792836044, -0.017950610488622395,
                                  -0.0024423059245917453, -0.0016452441463414363, -0.0093515459983475116,
                                  0.0057576200971389208, -0.033095547928402878, -0.00280125266259403,
                                  -0.00234753844551528, 0.00076612030115199, 0.0015781691637181121,
                                  -0.01252347061773406, -0.0015807553885787188, -0.001433632933807447,
                                  -0.018081402767688413, 0.011823109482781329, -0.071092216743145781,
                                  -0.00474226908980296, -0.0035880157282166748, -0.013188274373546869,
                                  0.0061472460900185953, -0.034221561267767708, -0.0029209593750425485,
                                  -0.0025035616372318247, -0.004382621346218603, 0.0019173069513797665,
                                  -0.0085204820298797439, -0.001477926621277621, -0.0014343249834492247,
                                  -0.032570332777713068, 0.015586238937319346, -0.0259256083751292,
                                  -0.0058165845941275029, -0.0048184673692035617, -0.059276366369506062,
                                  0.02382616626797926, -0.087438239236661053, -0.0081111675549363355,
                                  -0.0065495350858224225, 0.0040015586475641443, -0.0028739405376594115,
                                  0.0065981739745461388, 0.0020100569354605429, 0.0018375292089136998,
                                  -0.039062870224452012, 0.018565136711855761, -0.069909300770276489,
                                  -0.0064472452720009512, -0.00510370072342836, -0.049225375994114591,
                                  0.021225881609237916, -0.073071466133619076, -0.0073179162442776561,
                                  -0.005869029244042384, 0.0003485182108680881, -0.0015850162559512581,
                                  -0.01532099440994757, 0.0014775787126371297, 0.0014006435240659259,
                                  -0.013322834953552288, 0.0077016392049812695, 0.032221551195716645,
                                  -0.0026446585538531177, -0.0021371287308110196, -0.0057159517577120393,
                                  0.0026197342449296498, -0.012018581705523834, -0.0018239337271427798,
                                  -0.0016681296594233427, -0.020769108822265462, 0.014846711446887073,
                                  0.015908765682329986, -0.0051679233239096756, -0.0041500337330696848,
                                  -0.0040899520963270063, 0.0024692391599725797, -0.015373698795688244,
                                  -0.001822175659594531, -0.0016866325571780886, 0.012887324758345118,
                                  -0.0075188848322882973, 0.0043242656485228482, 0.00333538937951608,
                                  0.0028253017430623995, -0.0040079628030766784, 0.0008153818331921572,
                                  -0.0097420180644894865, 0.00086652362872937066, 0.00095225434509548727,
                                  -0.019459990610555079, 0.0084642584937447522, -0.025732405431826342,
                                  -0.0036645629731632272, -0.0031197404651318022, 0.021606710293901966,
                                  -0.0073695352574742658, 0.033674310536898504, 0.0011655473422810419,
                                  0.00064415109104615112, 0.02804805957265567, -0.01193544348463488,
                                  0.051068858195794681, 0.0044527617552987614, 0.0036899443413676478,
                                  -0.00088839468891625524, -0.0013701997519640389, -0.10677947472335608,
                                  0.00026452051650405103, 0.00044113320924550283, 0.026668540446423809,
                                  -0.010187202259954843, 0.042248877604080852, 0.0019639823578813031,
                                  0.0012305839007044229, 0.029975423651659078, -0.011635720128009567,
                                  0.036591760158566904, 0.0025734211702024994, 0.0017423717164386087,
                                  -0.005050561276251973, 0.0071873552668106355, -0.026599970468111786,
                                  -0.0031183134504682779, -0.0024605991938576061, -0.016350855142949944,
                                  0.010897606664332222, -0.039927036798100349, -0.0041405474740496238,
                                  -0.0030583738918860083, -0.0339047367918081, 0.014960332133660234,
                                  -0.070454480261069957, -0.0053856600789966569, -0.00429246683633237,
                                  0.023264076697165074, -0.0096816334467403863, 0.027068990518715089,
                                  0.0040223181638556812, 0.0034239348903418311, 0.017695378732260125,
                                  -0.010390053926043421, 0.029718886470576144, 0.0042616111714354936,
                                  0.0035197178190718311, 0.015224578929844274, -0.0026490518405552629,
                                  0.034634034263135514, -0.00037733185263916338, -0.00043083876555976181,
                                  0.0025077650125796902, -0.00022421159701906809, -0.018853474932748155,
                                  -0.000686544088005402, -0.00071365908774106957, 0.0071320888813875914,
                                  -0.0023275902016073784, 0.00882535006136633, -0.00037782671231527127,
                                  -0.00057542077412308214, 0.015295070351055682, -0.0026078801044450467,
                                  -0.00416339747953789, -0.00016871213785071956, -0.00025853404673340479,
                                  0.00413537349251992, -0.0015427320778183984, 0.018988817937862848,
                                  0.0015195536108328907, 0.0014682778961832934, -0.016531436589222,
                                  0.008473273295383105, -0.02706045407583995, -0.0034751345370597534,
                                  -0.0029298260049041278, -0.032004832770580943, 0.015317144198565079,
                                  -0.052571016497926289, -0.0058881865327497515, -0.0047606128696510621,
                                  -0.017709692267780287, 0.016512392815825207, -0.097834340528936511,
                                  -0.006069984481435824, -0.004430501943640021, 0.020270523101856043,
                                  -0.0053179750932790884, 0.0090162238574388043, 0.0005094791488626135,
                                  0.00022432607600401358, -0.0076915945358781773, 0.00510440464736388,
                                  0.025361258008213074, -0.0018606020414358758, -0.0015238060969975972,
                                  -0.0072028091507877609, 0.002767325018186018, -0.021185045361471151,
                                  -0.001788059379604505, -0.0016679231135980381, 0.0037025041584858405,
                                  0.002820780502453029, -0.008899219722234, -0.0018498097991376935,
                                  -0.0013844722453095135, -0.041259310266357319, 0.01647944935878224,
                                  -0.032766943568602457, -0.0041389444540042876, -0.0031030464216236656,
                                  -0.04390296718389216, 0.020713580077846738, -0.16636948243078689,
                                  -0.0076630998373329847, -0.0059793832599260794, -0.050849324560667056,
                                  0.022463678350608075, -0.084355874772333042, -0.0065029199231498658,
                                  -0.0046135959263597552, -0.017833756995849732, 0.0070825184664107168,
                                  -0.0083060130423623021, -0.0025023942996738125, -0.0019934970486001962,
                                  0.035497964690550041, -0.012656181599859153, 0.0514795149097925,
                                  0.0026389063531526168, 0.0017901148806782534, -0.0065506572770553332,
                                  0.0091522934259120232, -0.017237990676806061, -0.0038194143420255135,
                                  -0.0030139585237653355, 0.017801817891959386, -0.0060281372428480128,
                                  0.027673312557028418, 0.00081100013623414482, 0.00038319372417031073,
                                  0.010135400013140089, -0.00096239344514241075, 0.0095581465491140424,
                                  -0.00083906361985132481, -0.00075976641436253283, -0.019634863661538514,
                                  0.0072921144596565859, -0.034709944188568154, -0.0012937990006309779,
                                  -0.00071480995763740954, -0.028390129024086011, 0.0097333023408962722,
                                  -0.027824972843915066, -0.0018814025664831246, -0.0012589351781560349,
                                  0.039067651587864814, -0.01464312653954074, 0.037530274953926378,
                                  0.0035065577797539142, 0.0025134663239940926, -0.017794319002186809,
                                  0.013570877446469756, 0.0074974476475217029, -0.005123966657620333,
                                  -0.0039100270183707484, 0.026943065016000578, -0.0093309638255877538,
                                  0.030735745370032121, 0.0018598362580071535, 0.0011658304985063715,
                                  0.015842130514696792, -0.0065169754883458372, 0.015862829176743833,
                                  0.0030006574210797721, 0.0026404822365378626, -0.013985086178150209,
                                  0.0057962933872446392, -0.024629067477487533, -0.0027669316572652334,
                                  -0.0024251870775893304, 0.010786019891096727, -0.003267338152127275,
                                  0.011060902840230678, -6.8098834718846016E-5, -0.00030072548687003258,
                                  -0.011876710960182463, 0.0061444541853494152, -0.026636481339179573,
                                  -0.0027003986609743335, -0.0022874787640121655, -0.00269186313534648,
                                  0.0022678847201760581, -0.0097764309980574188, -0.0018046772094106722,
                                  -0.0016661478726901176, 0.011426740630461181, -0.0019033050109851914,
                                  0.021843654888423897, -0.00058177308787531244, -0.00069788457400063214,
                                  -0.012566955345845562, 0.0059488740302155244, -0.024132956399949817,
                                  -0.00292606834761796, -0.002548331286469762, -0.021846809210228909,
                                  0.010860744939423222, 0.015151590523520341, -0.00382131498074736,
                                  -0.0031265687507728832, -0.025926645927177059, 0.010951595024515834,
                                  -0.028302600763275228, -0.0043687247699301917, -0.003688630139734039,
                                  0.04577955781067717, -0.017976968765568421, 0.049321152858786139,
                                  0.0044724154691647118, 0.0032441369408285612, -0.0081603634681115828,
                                  0.0046163530016089952, -0.009834593390721692, -0.0024955469217555495,
                                  -0.002193775195534715, -0.0083049529662172026, 0.0035359377597029697,
                                  0.0058740671797315215, -0.002118717607468526, -0.0019459517493411649,
                                  -0.031908632984469054, 0.014952164354184632, -0.0442324825677253,
                                  -0.0053356219580107259, -0.0043023395550976593, -0.033899190574754968,
                                  0.013670567509549857, -0.046326952426847832, -0.0050718057116512522,
                                  -0.0039810140940196442, -0.024872895999397359, 0.012223847069414678,
                                  0.021388145349081646, -0.0038753072017128688, -0.0029619787425923059,
                                  0.026854979086428931, -0.010081434145411227, 0.018137738511945129,
                                  0.0021366359682461708, 0.0014165209063057075, -0.10050298900597951,
                                  0.0423773913567166, -0.1533451870483033, -0.013725952427308931,
                                  -0.010792993389035117, -0.05063795710369004, 0.022163957102456593,
                                  -0.080437785265183012, -0.0079737376485744752, -0.0063576779453270327,
                                  0.0051805689334850106, -0.00066960994539893984, 0.011636105752054171,
                                  -0.00089588872766976826, -0.00096254330243488156, -0.068427248476617408,
                                  0.028789565431632611, -0.039344623365652844, -0.0091087186938052355,
                                  -0.007190733652502332, 0.031588628622187476, -0.012132293965729247,
                                  0.02525588712759393, 0.0026241984018593213, 0.0017937276186895132,
                                  -0.00047641057901451963, -0.0015247983000539881, -0.0033106196083038902,
                                  0.0012392989130226349, 0.0011855227279696881, 0.026386671421405036,
                                  -0.0097076990818129854, 0.025401282553431489, 0.0019768561310235669,
                                  0.0013270140513981226, 0.033439372020637508, -0.012305689357683504,
                                  0.026150438004722894, 0.0029151196538078419, 0.0021648575886463592,
                                  0.0089820870096275277, -0.0069812884569827108, 0.033340861522476346,
                                  0.0028920072144891147, 0.0023263866383842957, 0.0059070658593133665,
                                  -0.001011350103106284, 0.030794428683608193, 0.000926470854489426,
                                  0.00090855362710569169, -0.00012160447586253999, 0.0022730956960204745,
                                  -0.033216152824397195, -0.00088471729685473191, -0.00062192632177497957,
                                  0.0060564614713260554, -0.0048046720084598893, 0.030140918414736366,
                                  0.002440950024563915, 0.002051751201758724, -0.000403263490049212,
                                  0.001041780555974308, 0.0019008369915159374, -0.0013309445849830662,
                                  -0.0013179188275414123, 0.026561912641227342, -0.012472486499764493,
                                  0.042325809974970527, 0.0032407100314383592, 0.0023237774126168638,
                                  0.032341847653789633, -0.012127557629171918, 0.036888673111585064,
                                  0.0027924746211162002, 0.0019157676393173294, 0.031177779095650397,
                                  -0.01308871208056543, 0.032030635759782052, 0.0030764991810423373,
                                  0.0021223063652783206, 0.010396740901347689, -0.0029775914168798973,
                                  -0.024792658731590592, 0.0018843708529304544, 0.0016280050492289819,
                                  -0.013789823324863592, 0.00309297519431911, -0.0369549938370682,
                                  -0.0015901553824918453, -0.0014665290717657041, -0.013085536359150642,
                                  0.0043018812733293, 0.0043228483077093595, -0.00113579580868955,
                                  -0.00094063888422230414, 0.03946582940637941, -0.020565879005786564,
                                  0.0750797546490494, 0.0071029715302533877, 0.0054876613527323906,
                                  0.010556528050019248, -0.0049104210231113487, 0.00786682703785971,
                                  0.0015687652003819534, 0.0011839456931703192, 0.025535519902278474,
                                  -0.011162769821928506, 0.090384857762360021, 0.0033101225776917841,
                                  0.0022825026609093581, 0.0063012921180224729, -0.0021263085507275993,
                                  0.0083112927784063442, -0.00043257299208364477, -0.00061672088318970547,
                                  -0.0049223592775691234, -0.00237301957653741, 0.06185321647903437,
                                  0.00080563407258445489, 0.00045514921344396906, -0.0051183236657519676,
                                  0.0029107932788190989, 0.00314774476394106, -0.0018968704886640232,
                                  -0.0016776946270023296, 0.0026015038667305951, 0.00026184799973075418,
                                  0.0052442538124851112, -0.0010781280948541317, -0.0010877589933454101,
                                  0.053663567076439329, -0.018408044804790791, 0.046285556747165307,
                                  0.0062915033722760168, 0.0052432758788900037, 0.028280045773713007,
                                  -0.010358777747885347, 0.039147943926787644, 0.0021486322184962139,
                                  0.001351234270816247, -0.014820724628848156, 0.0014129208667020929,
                                  0.036324920551580556, -0.00016400518552536392, -0.00048915987181829407,
                                  0.034652761815494551, -0.011985577158202339, 0.073288897598740688,
                                  0.0036173672587348727, 0.0028397479447291184, 0.0079617602881023822,
                                  -0.00426532780539015, -0.012048533894966962, 0.0014786174185710433,
                                  0.0012436578199729691, 0.036491494069057204, -0.014337315560081797,
                                  0.068222429782468452, 0.0033232551804665894, 0.002273554126011611,
                                  -0.0081922642198141247, 0.0040470362883265809, -0.022889854467307413,
                                  -0.002179494027987026, -0.00194619098469714, 0.01004273575335328,
                                  -0.0040548238613016688, 0.00073337059783097375, 0.0002783796425641437,
                                  -7.18168403905622E-5, -0.040584666149804417, 0.016922945123162211,
                                  -0.056517921249723158, -0.0061015610021436647, -0.0050097745586373454,
                                  -0.036865252588791642, 0.015023471678932459, -0.057353930407278937,
                                  -0.0053255611622006075, -0.004327997047595537, 0.006752727002508176,
                                  -0.0032829967572149338, -6.0721349721434853E-5, 0.002059709884921118,
                                  0.0018847645491892964, 0.034547279013372796, -0.014434746980436003,
                                  -0.015212186023469928, 0.00416529075826107, 0.0031443453166701916,
                                  0.023281853961415081, -0.0097062404050225429, 0.059575599884918784,
                                  0.0021124096794791066, 0.0012635594241346096, 0.017492435704133474,
                                  -0.0075215763465042405, 0.046999423046355793, 0.0017589486398448585,
                                  0.0011044068810846536, 0.012644035491436632, -0.0054218932610264605,
                                  0.032784552631501193, 0.0023545033632100488, 0.0019063427556647878,
                                  0.051949092777279861, -0.021091718963732842, 0.10291806325109114,
                                  0.0064724367076607718, 0.0047793852635109437, -0.028997437698103447,
                                  0.0105502693635025, 0.10379249492626552, -0.0040809108600700448,
                                  -0.0035902496499447788, -0.03453521064396961, 0.014594586806790651,
                                  -0.053570572355648216, -0.0054640011604754467, -0.0045146856127294384,
                                  -0.013198919296001732, 0.0053468257696183017, -0.013048109913632772,
                                  -0.0024387681571525731, -0.0021516805483354304, 0.034754432192678646,
                                  -0.017638012448188873, 0.048312261285846571, 0.0060585606390460532,
                                  0.0047992816067260495, -0.00976110324312434, 0.00602047987031576,
                                  0.024793240138287563, -0.002559707448351275, -0.0020862102357570686,
                                  -0.022470263024826496, 0.0097269923811831027, -0.049829006633056394,
                                  -0.0039065033259971394, -0.0032440174621084826, 0.013206124637477185,
                                  -0.00442370170078263, 0.011412703787004094, 0.00026880382692418735,
                                  -4.499513970555493E-5, 0.018071023798957139, -0.0047821512679322772,
                                  0.019093247409552296, 0.00079262593482501648, 0.00051793353969108744,
                                  -0.00066353674588301925, 0.00077514689943411431, -0.0064290868361989934,
                                  -0.0013211124605900866, -0.0013049578715345011, 0.026011367356091837,
                                  -0.0099190731519962824, 0.1121520592128577, 0.0031721620773675257,
                                  0.0022445268159155727, 0.024133340811263726, -0.015177172276438234,
                                  0.018761224918889572, 0.0058480614688004905, 0.0045863193541311152,
                                  0.0035869279242408255, -0.0041425912442644413, 0.042558058127364233,
                                  0.0018433520358954445, 0.0013818814822538869, -0.016989903108321443,
                                  0.0073775443387882429, -0.0370890346260246, -0.0031565281470463964,
                                  -0.00267587607216406, -0.01242498460543129, 0.0061853713077330589,
                                  -0.022983041345589306, -0.0028590104856227785, -0.0025064764009399714,
                                  0.00999811855507295, -0.0052032159127939773, 0.012730229963027083,
                                  0.0017649489737645786, 0.0012328830269165228, -0.049816068087584972,
                                  0.017468494692676414, -0.0062589134896305883, -0.0059103448915409224,
                                  -0.0045989299670706257, 0.00079731091954824275, -0.00082236156821367877,
                                  -0.0032908845264849555, -0.00064114519270972706, -0.000797286880180374,
                                  0.029237207435273454, -0.011225314646826502, 0.029996165768161321,
                                  0.002440672669355679, 0.0016601686109165286, 0.034083795672265167,
                                  -0.018872697579804264, 0.06443680428584958, 0.0063674293628531407,
                                  0.0048584944614656518, 0.013026673001299225, -0.0073214975498262641,
                                  0.014217287479837384, 0.0032854217699986878, 0.0027499091496460976,
                                  0.006389648284429084, -0.0017938144702220925, -0.010451810560660831,
                                  -0.00033339936656803858, -0.00044193361276528159, -0.0020296537029163646,
                                  -0.0010252910524065609, 0.023894254706241139, 0.00057295056792411141,
                                  0.00027677259157728466, 0.00816005340836007, -0.0019317519528719469,
                                  0.0068213631886383753, -0.00049017981518280406, -0.00061892719303571818,
                                  -0.0064853677492324006, 0.0014216902457474525, -0.0035815578697098878,
                                  0.00070622523465205668, 0.00079162410733994324, 0.012751280597374293,
                                  -0.00767828564707516, 0.02117730483802481, 0.0034719515879441643,
                                  0.0027518939625730166, -0.012976638863037852, 0.0022471278439513869,
                                  -0.0066238245583279485, 0.00025689369914140342, 0.00030679997296571864,
                                  -0.013448155877587496, 0.0096162417369387715, 0.029772390769185305,
                                  -0.0037417623010128865, -0.0029086611893493586, -0.028260763238476896,
                                  0.0101298982300478, -0.041626167289131294, -0.0021194018375642631,
                                  -0.0014055980333839821, 0.040869533340494833, -0.017465984232541809,
                                  0.10816484842772679, 0.0047285028883531817, 0.0034408489803297139,
                                  0.0262474972643792, -0.0099067653418300431, 0.039373977871431126,
                                  0.0019619757761366033, 0.001249491853103491, -0.030351814575086216,
                                  0.012692550389543823, -0.069832328179311121, -0.00469878145315582,
                                  -0.003905850505159748, 0.0438229471501485, -0.020931489254059743,
                                  0.092363189565098008, 0.0057878585271502617, 0.0041582409108271365,
                                  -0.010111164230359416, 0.00201916014610349, -0.016284892583256702,
                                  -0.00019874390905407909, -0.000351216248543199, 0.028747827897277884,
                                  -0.0089330088108831984, 0.034581705862076172, 0.0016752534378872632,
                                  0.001123066687074989, 0.027876489273205733, -0.010467871271493042,
                                  0.035856920686830378, 0.0020822123339460877, 0.0013568181422978626,
                                  0.022033473255383684, -0.010446425944955751, 0.018387590083982906,
                                  0.0043180196150216267, 0.0035833957830718765, 0.068376693617234766,
                                  -0.026674054389475947, 0.063748226263192015, 0.0070956010816627061,
                                  0.0052499599036286261, -0.020238199158505828, 0.0071758142169562628,
                                  0.012850783499939251, -0.0018417998397215983, -0.0015152440923610082,
                                  -0.0092024961247517256, 0.00435360046169703, -0.01401480131040452,
                                  -0.0023098213987736444, -0.0020512221533752163, 0.013192586408243239,
                                  -0.006513352790968951, 0.011806487229857429, 0.0014541250175256115,
                                  0.00086138395135293769, 0.014588689850638223, -0.0034568419653011671,
                                  0.065517619743043223, 0.00060228348599293731, 0.00037523539255889676,
                                  -0.031917368293341429, 0.0074572062917403941, -0.024693600861298692,
                                  -0.0017089756466168887, -0.0014710337670020366, 0.0027103121718143643,
                                  -0.0011389449719032762, -0.000529375760813832, 0.00048617278439922065,
                                  0.00049988895332187542, -0.0023239039922825023, -0.0018088180589296771,
                                  -0.012722072730015082, 0.00077887128590925037, 0.0005355539612269557,
                                  -0.023760501262262097, 0.0092020449593978211, -0.040297046878850371,
                                  -0.0034296022558444545, -0.0028812401468900906, 0.036993293576491677,
                                  -0.010395309382084023, 0.043506390553095763, 0.0022227108804200911,
                                  0.0016997374524885046, 0.00081922670877456946, -0.00079026928677211118,
                                  0.028380194680396792, -0.00036179384494206056, -0.00064526589431157587,
                                  0.0067178182435136376, -0.0021239908708534341, 0.0049804441344762579,
                                  0.00071135494640454282, 0.00059555611981829321, 0.0082351999811060457,
                                  -0.0018088599977345088, 0.00867472491601683, -0.0005676218538560188,
                                  -0.00069707995640774453, 0.011679512576608408, -0.0033022744237793953,
                                  0.027194695685992046, 0.0002465168952459831, -2.5469226243495106E-5,
                                  0.009865933402182378, -0.007368004592748216, 0.012019166225382944,
                                  0.0022386892765126308, 0.001382892781155891, 0.043614414283527261,
                                  -0.018629638072032786, 0.051420033100278796, 0.0059599336909502906,
                                  0.0047587566633858257, 0.030090952081588841, -0.01177471888029134,
                                  0.02573850467288662, 0.0038084344948406314, 0.00302243748879344,
                                  0.0032478204047372973, -3.4515534848327157E-5, 0.0099481175542020031,
                                  -0.00093686603471922658, -0.00098123256895918582, -0.0012118584106250579,
                                  0.00088784003507113, -0.009825743549465164, -0.001217714059541135,
                                  -0.0011653432196169348, 0.02551618601737346, -0.0095178675346350647,
                                  0.024306758603880443, 0.0019300670231968092, 0.0012638843360256273,
                                  0.003801741784766729, -0.00015586333567548167, 0.0071705972360725382,
                                  -0.00099193699831028764, -0.0010074438329813321, 0.022931094366361007,
                                  -0.013480165999786468, 0.058714607227712434, 0.0045283642287102079,
                                  0.0032647449420433929, -0.02678542315328198, 0.013874217451344055,
                                  -0.00034437444041442758, -0.0042889719639456012, -0.00336715787628993,
                                  0.01866505805719627, -0.0045405634863110072, 0.021817139226435377,
                                  0.0002859878611645531, 5.622750148297372E-5, -0.012736043368882823,
                                  0.0060789391500660171, -0.011186527941152795, -0.0028442015967096576,
                                  -0.0024679512671422284, 0.0088938686888462258, -0.0029856320955078384,
                                  0.012484704684900944, -0.00017395539928360471, -0.00040840368341395948,
                                  -0.02310532947772578, 0.011757582098689375, -0.0254135346023401,
                                  -0.0046644444200897349, -0.0038417578688483018, 0.0060569878131839922,
                                  -0.0035151842665098691, 0.048507068364320588, 0.0012729144288294808,
                                  0.00092817925472256715, -0.004319969959325925, 0.0002419512311127643,
                                  -0.0059276554603888906, 0.00016847445869682607, 2.1128274233919737E-5,
                                  0.0014928726608244352, -0.00065382991415268072, 0.021831515424137062,
                                  -0.00055858175228229434, -0.00075000646531477087, 0.031473102739748224,
                                  -0.011112025541124469, 0.047344166814825221, 0.0025065916925107045,
                                  0.0017089366569373972, 0.044367486640275115, -0.019027792658291472,
                                  0.07520553565485201, 0.0053223281280877074, 0.0038641129760316742,
                                  -0.014854731778070791, 0.00712940720168147, -0.0083433878631558912,
                                  -0.0032872145680999166, -0.0028071396356451248, 0.0095528361595460052,
                                  -0.0062363679162073266, 0.023439744398777756, 0.0021644062463430551,
                                  0.0017563436731591953, 0.026366397520079021, -0.012903769459637645,
                                  0.045134664004051708, 0.0035111764715894823, 0.0024709046372372867,
                                  -0.015954087210207538, 0.0070129799376013307, -0.048700580344077267,
                                  -0.0030857816937306637, -0.0025692521456310447, -0.021402331029462388,
                                  0.0077063116820870504, -0.040456301991726382, -0.0023034415122491808,
                                  -0.0017975777772051009, 0.040684903900175623, -0.01857724110826714,
                                  0.048244520906349182, 0.0063767637973494683, 0.00509484821932286,
                                  0.034415323578840695, -0.012432377292624402, 0.047816117744430717,
                                  0.002757071589958381, 0.0018868122292072418, 0.00927305462661962,
                                  -0.0016012192973603847, 0.018173936177631158, -0.00066200674583062646,
                                  -0.00076251338864492422, 0.034218956908526672, -0.0128224512839117,
                                  0.055412091646321389, 0.0028696015370856969, 0.0020604680918890951,
                                  0.02820465917386375, -0.012442643601293442, 0.038645147746305189,
                                  0.0049121930058473075, 0.0040735041421760924, -0.015734666854347774,
                                  0.0049153178525003071, -0.025801148226877669, -0.00029294825585445515,
                                  -2.8992953080258886E-5, 0.038473665699467779, -0.015015710235440374,
                                  0.049658319070642117, 0.0035027279496065754, 0.0025077309782528096,
                                  0.012441311383550291, -0.0057904468299014239, 0.061745593125666576,
                                  0.0010530216390578994, 0.00051036705600619476, -0.050519809498368547,
                                  0.0146765222659797, 0.042847514141701883, -0.004338980419195229,
                                  -0.0036939988477306569, 0.0037414906308416247, -0.0048429645426028723,
                                  0.10177921913418871, 0.0021580802197374589, 0.0014590542239076719,
                                  0.041755108314216048, -0.023611282933225258, 0.1000654216390793,
                                  0.008185422093670635, 0.0062791905079347815, 0.015753265342409856,
                                  -0.0059088545006081156, 0.023157161034454095, 0.00085086796032412973,
                                  0.0003683668598290855, -0.0062955778593385744, 1.1933594171885568E-5,
                                  -0.0070414764579604435, -3.2870239438996586E-5, -8.6155183454089625E-5,
                                  0.037187041450914858, -0.014806800300371238, 0.042611773385318685,
                                  0.0035819450675279659, 0.002564823674379896, -0.019611078409706838,
                                  0.0086002357520106633, -0.033322335003144909, -0.0035918744365637956,
                                  -0.0030633411037705965, 0.027756840751484369, -0.011765339051551631,
                                  0.057297332569039482, 0.0042696547961361235, 0.0035067967985853792,
                                  -0.01730617282780228, 0.0088169762587271411, -0.016049515737450965,
                                  -0.0038105540663450495, -0.003230605646528939, -0.0076009851372804155,
                                  0.0011958170086272984, -0.017271787944158505, -0.001075594997988713,
                                  -0.0010707931011323414, -0.022183402325015047, 0.0050191697638082887,
                                  -0.011612212546674496, -0.0016512083844754544, -0.0015426437426829371,
                                  0.024832440343822065, -0.010683784872074126, 0.026733600122250737,
                                  0.004204039213077217, 0.0035964392467720528, 0.0072017565982385179,
                                  -0.0081857196782728053, -0.0066826791561296695, 0.0037651688166562493,
                                  0.0030218735701345732, -0.0058791195571461386, 0.002850360869956263,
                                  0.0022349022269859452, 9.8732869412690146E-5, 0.00033918704874217752,
                                  -0.014978619188545428, 0.0054065499784512853, -0.022294407812036364,
                                  -0.0024224283011476016, -0.0021755480922475917, -0.0058435144680055008,
                                  0.0022083380509511385, -0.0034275057775240859, -0.0017150315188051725,
                                  -0.0016253591176029942, -0.017442464337373443, 0.0096412402966889882,
                                  0.015008919388916488, -0.003002583080828387, -0.0025277265795162021,
                                  0.011652817401650278, -0.0036435261779151312, 0.015083184336478109,
                                  4.7243482598341885E-5, -0.00021257778619793212, 0.029778644942234513,
                                  -0.016353956598202758, 0.095594212266871134, 0.0061354066726702237,
                                  0.0046457223202190107, 0.0020300758528275955, -0.00058219376466553732,
                                  -0.0096916891411583921, -0.00075140523939354537, -0.00083077180932045191,
                                  0.021574889579607064, -0.0074094055136971516, 0.03225970801520571,
                                  0.0011733514183002098, 0.00065653412858971642, -0.018023743270037858,
                                  0.0052436456326080058, 0.009606896145867851, -0.00086328501770055628,
                                  -0.0006031519213593713, 0.021691354536660941, -0.0069069899906729487,
                                  0.016198210575926734, 0.0011601126690698128, 0.00071226023612999808,
                                  0.0076047694242972067, -0.0038865339196614244, 0.048922204275405036,
                                  0.000920917372362909, 0.000371892690680407, 0.0137211418207954,
                                  -0.0050825610099418089, 0.00974567484386352, 0.0025014542624870865,
                                  0.0020902660688795027, 0.0018549768301429242, -0.0080835343147310727,
                                  -0.0051896401052734364, 0.0031429928191197263, 0.0022949662193009518,
                                  -0.02150205740236644, 0.0033277708931986885, -0.0014612468632900152,
                                  -0.00045394503765708934, -0.00040082045634224234, -0.042088871441664392,
                                  0.015945222162795987, -0.053226155305642335, -0.0056145177290492483,
                                  -0.0046693619853602208, 0.031074978876006271, -0.012372510409392775,
                                  0.043165688502726819, 0.0027373032090375446, 0.0018569972275530137,
                                  -0.010013432911027666, 0.0025367878205719112, -0.010554759598896032,
                                  0.00027177183755857243, 0.00044495462709987616, 0.030501651726791309,
                                  -0.016090829541563108, 0.058329497626477232, 0.0044022827846171789,
                                  0.0031465995982908408, 0.045088021365780863, -0.015146495122616527,
                                  0.0457354353626043, 0.0037429196443403406, 0.0027473590855801558,
                                  -0.008090646856816321, 0.000837969353505788, -0.034496694420148986,
                                  0.00059610214653741289, 0.0004539419070467518, -0.005591228645455428,
                                  0.0027124451376094121, 0.00077125416299426617, -0.0018666024185009895,
                                  -0.0017268406392333601, -0.00010096009851473327, 0.00098048985468610918,
                                  0.012055858568422066, -0.0013258497206396146, -0.0013153264636715147,
                                  0.023773936304775974, -0.010063031906645706, 0.030023961521007333,
                                  0.002055319938675304, 0.0013272643368262413, 0.039513405970723552,
                                  -0.013526640877859365, 0.062127012713288868, 0.0036881589084556605,
                                  0.0027798249278460237, -0.045002547728978895, 0.018149443951106431,
                                  -0.0676360317081294, -0.0064922681481917868, -0.0053266924705690057,
                                  -0.0070969722130770308, 0.00091204945358104225, 0.013032922164056189,
                                  0.00052720034062861507, 0.00032490504090167225, 0.0024127910514973048,
                                  -0.0017670198878754586, -0.015798916262890737, -6.9554744006272517E-5,
                                  -0.00036488382626174786, -0.01220424763792869, 0.005382703246759382,
                                  0.0064271498043307028, -0.0025949269593898159, -0.0022735910706659927,
                                  0.023085747069309766, -0.00918514719146978, 0.03021969448756108,
                                  0.0018588247802444153, 0.0011265820348943943, -0.017333055975008137,
                                  -3.0875338318615309E-5, -0.060844641316757493, 0.00075482862007723145,
                                  0.00057595854344437349, 0.020964365396106459, -0.0026921392177914998,
                                  0.047537383110413826, -0.00019700216176349409, -0.00012488567628313042,
                                  0.018919184543572623, -0.0077642437529066681, 0.026460898974318147,
                                  0.001529189859714694, 0.00094379165434460154 };
  
  static const double b_a[5] = { -0.506277707584869, 0.21194506695747822,
                                 -0.78415778676258219, -0.072309556585961957, -0.056379610623988545 };
  
  //  ===== NEURAL NETWORK CONSTANTS =====
  //  Input 1
  //  Layer 1
  //  Layer 2
  //  Output 1
  //  ===== SIMULATION ========
  //  Dimensions
  //  samples
  //  Input 1
  mapminmax_apply( REAL(x1), t0_xoffset, t0_gain, xp1, cpgs, samples);
  
  
  
  //  Layer 1
  //  Layer 2
  //  Output 1
  repmat(dv1, inobs);
  for (i0 = 0; i0 < 5; i0++) {
    for (i1 = 0; i1 < inobs; i1++) {
      d0 = 0.0;
      for (i2 = 0; i2 < cpgs; i2++) {
        d0 += a[i0 + 5 * i2] * xp1[i2 + cpgs * i1];
      }
      
      dv2[i0 + 5 * i1] = dv1[i0 + 5 * i1] + d0;
    }
  }
  
  tansig_apply(dv2, dv1, sizeobs5);
  for (i0 = 0; i0 < samples; i0++) {
    d0 = 0.0;
    for (i1 = 0; i1 < 5; i1++) {
      d0 += b_a[i1] * dv1[i1 + 5 * i0];
    }
    
    dv3[i0] = -0.095433086971430062 + d0;
  }
  
  mapminmax_reverse(dv3, b_y1, inobs);
}

//
// File trailer for NewModel1Clean.cpp
//
// [EOF]
//
