% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_by_windows.R
\name{tile_by_windows}
\alias{tile_by_windows}
\title{Group cytosine / CpG level data into regions based on genomic windows}
\usage{
tile_by_windows(bs, win_size = 200)
}
\arguments{
\item{bs}{a \code{BSseq} object.}

\item{win_size}{an \code{integer} indicating the size of the tiles. Default is 200bp.}
}
\value{
A \code{BSseq} object with loci consisting of a tiling of the genome by \code{win_size} bp tiles. Coverage and methylation read count matrices are aggregated by the sums of the cytosines / CpGs in the regions per sample.
}
\description{
An optional function to aggregate cytosine / CpG level data into regions based on a tiling of the genome by \code{win_size}.
}
\examples{
data(bsseq_stranded, package = 'methylSig')

tiled = tile_by_windows(bs = bsseq_stranded, win_size = 50)

}
