% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeCoverage.R, R/methylDBFunctions.R
\docType{methods}
\name{normalizeCoverage}
\alias{normalizeCoverage}
\alias{normalizeCoverage,methylRawList-method}
\alias{normalizeCoverage,methylRawListDB-method}
\title{normalize read coverage between samples}
\usage{
normalizeCoverage(obj,method="median",chunk.size,save.db,...)

\S4method{normalizeCoverage}{methylRawList}(
  obj,
  method = "median",
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{normalizeCoverage}{methylRawListDB}(
  obj,
  method = "median",
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)
}
\arguments{
\item{obj}{\code{methylRawList} or \code{methylRawListDB} object}

\item{method}{a string "mean" or "median" which denotes median or mean 
should be used to calculate scaling factor. (Default:median)}

\item{chunk.size}{Number of rows to be taken as a chunk for processing 
the \code{methylRawListDB} objects. (Default: 1e6)}

\item{save.db}{A Logical to decide whether the resulting object should 
be saved as flat file database or not, default: explained in Details sections}

\item{...}{optional Arguments used when save.db is TRUE

\code{suffix}
      A character string to append to the name of the output 
      flat file database, 
      only used if save.db is true, default actions: append 
      \dQuote{_filtered} to current filename 
      if database already exists or generate new file with 
      filename \dQuote{sampleID_filtered}
      
\code{dbdir} 
      The directory where flat file database(s) should be stored, 
      defaults
      to getwd(), working directory for newly stored databases
      and to same directory for already existing database}
}
\value{
a  \code{methylRawList} or \code{methylRawList} object 
depending on class of input object
}
\description{
The function normalizes coverage values between samples using a scaling 
factor derived from differences between mean or median of coverage distributions
}
\section{Details}{

The parameter \code{chunk.size} is only used when working with 
\code{methylRawListDB} objects, 
as they are read in chunk by chunk to enable processing large-sized 
objects which are stored as flat file database.
Per default the chunk.size is set to 1M rows, which should work for 
most systems. If you encounter memory problems or 
have a high amount of memory available feel free to adjust the
 \code{chunk.size}.

The parameter \code{save.db} is per default TRUE for methylDB objects as
 \code{methylRawListDB}, 
while being per default FALSE for \code{methylRawList}. If you wish to 
save the result of an 
in-memory-calculation as flat file database or if the size of the 
database allows the calculation in-memory, 
then you might want to change the value of this parameter.
}

\examples{

data(methylKit)
# normalize by the median coverage
newObj = normalizeCoverage(methylRawList.obj,method="median")

# normalize by mean coverage and save to database in folder methylDB
newDBObj = normalizeCoverage(methylRawList.obj,method="mean",
save.db=TRUE,dbdir="methylDB")

}
\author{
Altuna Akalin
}
