% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylDBClasses.R
\docType{class}
\name{methylRawListDB-class}
\alias{methylRawListDB-class}
\alias{methylRawListDB}
\title{An S4 class for holding a list of methylRawDB objects.}
\usage{
methylRawListDB(..., treatment)
}
\arguments{
\item{...}{vector of methylRawDB files}

\item{treatment}{vector of treatment values}
}
\description{
This class stores the list of  \code{\link{methylRawDB}} objects.
Functions such as \code{lapply} can be used on this list. It extends
 \code{\link[base]{list}} class. This object is primarily produced
by \code{\link{methRead}} function.
}
\section{Slots}{
\describe{
                 \item{\code{treatment}}{numeric vector denoting control
                  and test samples}
                 \item{\code{.Data}}{a list of \code{\link{methylRawDB}} objects  } 
               }
}

\section{Constructor}{
\describe{
                 \item{\code{methylRawListDB(...)}}{combine multiple methylRawDB
                 objects supplied in ... into a methylRawListDB object.}
               }
}

\examples{
file.list=list( system.file("extdata", "test1.myCpG.txt", 
package = "methylKit"),
                system.file("extdata", "test2.myCpG.txt", 
                package = "methylKit"),
                system.file("extdata", "control1.myCpG.txt", 
                package = "methylKit"),
                system.file("extdata", "control2.myCpG.txt", 
                package = "methylKit") )

methylRawListDB.obj <- methRead(file.list,
sample.id = list("test1","test2","ctrl1","ctrl2"),
                            assembly = "hg18",treatment = c(1,1,0,0),
                            dbtype = "tabix",dbdir = "methylDB")

#applying functions designed for methylRawDB on methylRawListDB object
lapply(methylRawListDB.obj,"getAssembly")


# remove Database again
rm(methylRawListDB.obj)
unlink("methylDB",recursive=TRUE)

}
