% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnnot.R
\name{getAnnot}
\alias{getAnnot}
\title{Get CpG annotation}
\usage{
getAnnot(array.type, group = "all")
}
\arguments{
\item{array.type}{A string. Either "450K" or "EPIC". Default is "450K".}

\item{group}{A string. "all", "body", "promoter1" or "promoter2". 
Default is "all". If group = "body", only CpGs on gene body will be 
pulled out. If group = "promoter1" or group = "promoter2", 
only CpGs on promoters will be pulled out. Here is the definition of "body", 
"promoter1" and "promoter2" according to the annotation in 
IlluminaHumanMethylation450kanno.ilmn12.hg19 or 
IlluminaHumanMethylationEPICanno.ilm10b4.hg19. 
\itemize{
  \item body: CpGs whose gene group correspond to "Body" or "1stExon" 
  \item promoter1: CpGs whose gene group correspond to "TSS1500" or "TSS200"
  \item promoter2: CpGs whose gene group correspond to "TSS1500", "TSS200", 
  "1stExon", or "5'UTR". 
}
If group = "all", all CpGs will be pulled out.}
}
\value{
A data frame contains CpG IDs and gene symbols.
}
\description{
This function gets CpG IDs and their corresponding gene symbols.
}
\details{
The implementation of the function is modified
from .flattenAnn function in missMethyl package.
}
\references{
Hansen KD (2016). IlluminaHumanMethylation450kanno.ilmn12.hg19:
Annotation for Illumina's 450k methylation arrays. R package version 0.6.0.

Hansen KD (2017). IlluminaHumanMethylationEPICanno.ilm10b4.hg19:
Annotation for Illumina's EPIC methylation arrays. R package version 0.6.0,
https://bitbucket.com/kasperdanielhansen/Illumina_EPIC.

Phipson B, Maksimovic J and Oshlack A (2015).
“missMethyl: an R package for analysing methylation data from
Illuminas HumanMethylation450 platform.” Bioinformatics, pp. btv560.
}
