% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluatePerformance.R
\name{evaluatePerformance}
\alias{evaluatePerformance}
\title{Evaluate performance metrics: root mean square error (RMSE), 
mean absolute error (MAE), mean absolute percentage error (MAPE) and
Pearson correlation coefficient (PCC).}
\usage{
evaluatePerformance(beta_true, beta_imputed, na_positions)
}
\arguments{
\item{beta_true}{first numeric data matrix.}

\item{beta_imputed}{second numeric data matrix}

\item{na_positions}{a list where each element is a list of two elements: 
column id and ids of rows with NAs in that column (structure matches the 
output of generateMissingData function). We need this because some NAs in 
the dataset are from real data and not artificial, so we can't evaluate the 
performance of the method on them since we do not know real value. 
Therefore, we need to know the positions of artificial NAs.}
}
\value{
A numerical vector of four numbers: root mean square error (RMSE), 
mean absolute error (MAE), mean absolute percentage error (MAPE) and
Pearson correlation coefficient (PCC).
}
\description{
This function computes performance metrics as an element-wise difference 
between two matrices (skipping NA elements that were not imputed): 
* \eqn{RMSE = \sqrt{\sum_i (true_i - est_i)^2 / \#NAs)}};
* \eqn{MAE = \sum_i |true_i - est_i| / \#NAs};
* \eqn{MAPE = \dfrac{100}{n} \sum_i |true_i - est_i / true_i|} 
(here we omit the true beta-values equal to 0 and their  predicted values
to  avoid an indeterminate measure);
* \eqn{PCC = \dfrac{\sum_i (true_i - \bar{true_i}) \sum_i(est_i - \bar{est}_i)}{\sqrt{\sum_i (true_i - \bar{true}_i)^2}} \sqrt{\sum_i(est_i - \bar{est_i})^2}}.
}
\examples{
data(beta)
with_missing_data <- generateMissingData(beta, lambda = 3.5)
beta_with_nas <- with_missing_data$beta_with_nas
na_positions <- with_missing_data$na_positions
beta_imputed <- methyLImp2(input = beta_with_nas, type = "EPIC", 
                          minibatch_frac = 0.5,
                          BPPARAM = BiocParallel::SnowParam(workers = 1))
evaluatePerformance(beta, beta_imputed, na_positions)
}
