% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binMethylome.R
\name{binning}
\alias{binning}
\alias{binCounts}
\alias{binPositions}
\alias{binMethylome}
\title{Methimpute binning functions}
\usage{
binCounts(data, binsize)

binPositions(data, binsize)

binMethylome(data, binsize, contexts = "total", columns.average = NULL)
}
\arguments{
\item{data}{A \code{\link[GenomicRanges]{GRanges-class}} object with metadata columns 'context' and 'counts' (which is a matrix with columns 'methylated' and 'total').}

\item{binsize}{The window size used for binning.}

\item{contexts}{A character vector with contexts for which the binning will be done.}

\item{columns.average}{A character vector with names of columns in \code{data} that should be averaged in bins.}
}
\value{
A \code{\link[GenomicRanges]{GRanges-class}} object for \code{binCounts} and \code{binPostions}. A \code{list()} of \code{\link[GenomicRanges]{GRanges-class}} objects for \code{binMethylome}.
}
\description{
This page provides an overview of all \pkg{\link{methimpute}} binning functions.
}
\section{Functions}{
\itemize{
\item \code{binCounts}: Get the aggregated number of counts in each bin (no context).

\item \code{binPositions}: Get the number of cytosines in each bin (total and per context).

\item \code{binMethylome}: Get number of cytosines and aggregated counts for the specified contexts.
}}

\examples{
## Get some toy data
file <- system.file("data","arabidopsis_toydata.RData",
                    package="methimpute")
data <- get(load(file))
print(data)
## Bin the data in various ways
binCounts(data, binsize=1000)
binPositions(data, binsize=1000)
binMethylome(data, binsize=1000, contexts=c("total", "CG"),
            columns.average=NULL)

}
