/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures;

import fr.cea.ig.metatarget.datastructures.ClusterPoisson;
import fr.cea.ig.metatarget.datastructures.Dictionary;
import fr.cea.ig.metatarget.utils.Utils;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class EMold {
    private static final int maxRuns = 25;
    private static final double CONVERGE_THRESHOLD = 1.0E-5;
    private int numberOfClusters;
    private Dictionary dictionary;
    private int excludeMin;
    private int excludeMax;
    private double kmerThreshold = 0.5;
    private double readThreshold = 0.5;
    private int kmerHighestCount;
    private double[] clusterSizes;
    private double[] clusterAbundances;
    private double[] currAbundances;
    private double[] currClassSize;
    private double[] prevClassSize;
    private double[] prevClassAbundance;
    private double[][] countPoissonClass;

    public double[] getClusterAbundances() {
        return this.clusterAbundances;
    }

    public double[] getClusterSizes() {
        return this.clusterSizes;
    }

    public EMold(int numberOfClusters, int excludeMin, int excludeMax, Dictionary dictionary) {
        this.numberOfClusters = numberOfClusters;
        this.dictionary = dictionary;
        this.excludeMin = excludeMin;
        this.excludeMax = excludeMax;
        this.kmerHighestCount = this.dictionary.getMaxCount();
        if (excludeMax != 0 && this.kmerHighestCount > excludeMax) {
            this.kmerHighestCount = excludeMax;
        }
        this.kmerThreshold = 1.0 / (double)numberOfClusters;
        this.clusterSizes = new double[numberOfClusters];
        this.clusterAbundances = new double[numberOfClusters];
        this.currAbundances = new double[numberOfClusters];
        this.currClassSize = new double[numberOfClusters];
        this.prevClassSize = new double[numberOfClusters];
        this.prevClassAbundance = new double[numberOfClusters];
        int j = 10 * (numberOfClusters - 1);
        for (int i = 0; i < numberOfClusters; ++i) {
            this.clusterAbundances[i] = j;
            this.prevClassAbundance[i] = this.clusterAbundances[i];
            if ((j -= 10) == 0) {
                j = 1;
            }
            this.clusterSizes[i] = 1000000.0;
            this.prevClassSize[i] = this.clusterSizes[i];
        }
        this.countPoissonClass = new double[this.kmerHighestCount + 1][numberOfClusters];
    }

    private double safeDivideWith(double div) {
        return div == 0.0 ? 1.0 : div;
    }

    public void performEM() {
        try {
            CountDownLatch doneSignal = new CountDownLatch(this.numberOfClusters);
            for (int i = 0; i < this.numberOfClusters; ++i) {
                Thread t = new Thread(new EMThread(i, doneSignal));
                t.start();
            }
            doneSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class EMThread
    implements Runnable {
        private int clusterId;
        private CountDownLatch doneSignal;

        private EMThread(int clusterId, CountDownLatch doneSignal) {
            this.clusterId = clusterId;
            this.doneSignal = doneSignal;
        }

        @Override
        public void run() {
            int convflag;
            boolean zeroflag;
            int k = 0;
            do {
                System.out.println("Cluster=" + this.clusterId + "\tRun=" + ++k);
                ((EMold)EMold.this).currAbundances[this.clusterId] = EMold.this.clusterAbundances[this.clusterId];
                ((EMold)EMold.this).currClassSize[this.clusterId] = EMold.this.clusterSizes[this.clusterId];
                for (int cnt = 1; cnt <= EMold.this.kmerHighestCount; ++cnt) {
                    if (cnt < EMold.this.excludeMin || EMold.this.excludeMax != 0 && cnt > EMold.this.excludeMax) continue;
                    ((EMold)EMold.this).countPoissonClass[cnt][this.clusterId] = 0.0;
                    for (int j = 0; j < EMold.this.numberOfClusters; ++j) {
                        double lnSum = ClusterPoisson.lnPoissonProbabilitySum(EMold.this.currAbundances[j], EMold.this.currAbundances[this.clusterId], cnt, EMold.this.currClassSize[j]);
                        double tempSum = Math.exp(lnSum);
                        if (Double.isInfinite(tempSum)) {
                            ((EMold)EMold.this).countPoissonClass[cnt][this.clusterId] = Double.POSITIVE_INFINITY;
                            break;
                        }
                        double[] dArray = EMold.this.countPoissonClass[cnt];
                        int n = this.clusterId;
                        dArray[n] = dArray[n] + tempSum;
                    }
                    ((EMold)EMold.this).countPoissonClass[cnt][this.clusterId] = EMold.this.currClassSize[this.clusterId] / EMold.this.countPoissonClass[cnt][this.clusterId];
                }
                ((EMold)EMold.this).prevClassSize[this.clusterId] = EMold.this.clusterSizes[this.clusterId];
                ((EMold)EMold.this).clusterSizes[this.clusterId] = 0.0;
                ((EMold)EMold.this).prevClassAbundance[this.clusterId] = EMold.this.clusterAbundances[this.clusterId];
                ((EMold)EMold.this).clusterAbundances[this.clusterId] = 0.0;
                for (Map.Entry<Long, AtomicInteger> entry : EMold.this.dictionary.getHashMap().entrySet()) {
                    int count = entry.getValue().get();
                    if (count < EMold.this.excludeMin || EMold.this.excludeMax != 0 && count > EMold.this.excludeMax) continue;
                    double[] dArray = EMold.this.clusterSizes;
                    int n = this.clusterId;
                    dArray[n] = dArray[n] + EMold.this.countPoissonClass[count][this.clusterId];
                    double[] dArray2 = EMold.this.clusterAbundances;
                    int n2 = this.clusterId;
                    dArray2[n2] = dArray2[n2] + EMold.this.countPoissonClass[count][this.clusterId] * (double)count;
                }
                double[] dArray = EMold.this.clusterAbundances;
                int n = this.clusterId;
                dArray[n] = dArray[n] / EMold.this.safeDivideWith(EMold.this.clusterSizes[this.clusterId]);
                zeroflag = false;
                convflag = 0;
                if (EMold.this.clusterAbundances[this.clusterId] == 0.0 || EMold.this.clusterSizes[this.clusterId] == 0.0) {
                    zeroflag = true;
                    continue;
                }
                double fTemp = (EMold.this.clusterAbundances[this.clusterId] - EMold.this.prevClassAbundance[this.clusterId]) / EMold.this.safeDivideWith(EMold.this.prevClassAbundance[this.clusterId]);
                if (fTemp < 0.0) {
                    fTemp *= -1.0;
                }
                if (fTemp < 1.0E-5) {
                    ++convflag;
                }
                if ((fTemp = (EMold.this.clusterSizes[this.clusterId] - EMold.this.prevClassSize[this.clusterId]) / EMold.this.safeDivideWith(EMold.this.prevClassSize[this.clusterId])) < 0.0) {
                    fTemp *= -1.0;
                }
                if (!(fTemp < 1.0E-5)) continue;
                ++convflag;
            } while (!zeroflag && convflag != 2 && k < 25);
            System.out.println(Utils.time() + "\tCluster " + this.clusterId + " abundance=" + EMold.this.clusterAbundances[this.clusterId]);
            System.out.println(Utils.time() + "\tCluster " + this.clusterId + " length=" + EMold.this.clusterSizes[this.clusterId]);
            System.out.println(Utils.time() + "\tCluster " + this.clusterId + " Runs=" + k);
            this.doneSignal.countDown();
        }
    }
}

