% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_utils.R
\name{update_best_match}
\alias{update_best_match}
\title{Update best match info by ranking of tomtom data}
\usage{
update_best_match(res)
}
\arguments{
\item{res}{results from runTomTom}
}
\value{
`res` with updated best_* columns
}
\description{
This function updates the best_match columns based on the rankings on the
tomtom list data. By re-ordering the entries of a `tomtom` object, the
best_match columns can be updated to reflect the new rankings using
[update_best_match()], where the first row of the `tomtom` data.frame is
selected as the best match.
}
\examples{
data("example_dreme_tomtom")
# best match is "CG2052_SANGER_2.5"
example_dreme_tomtom$best_match_name[1]
# reorder the `tomtom` data.frame
example_dreme_tomtom$tomtom[[1]] <- dplyr::arrange(example_dreme_tomtom$tomtom[[1]],
                                                   dplyr::desc(match_eval))
# update_best_match will use the new order of rows, taking the top row as the new best match
new_res <- update_best_match(example_dreme_tomtom)
# best match is now altered:
new_res$best_match_name[1]
}
\seealso{
[force_best_match()]
}
