% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logisitic_Regression.R
\name{logitPlotSnpTaxa}
\alias{logitPlotSnpTaxa}
\title{logitPlotSnpTaxa produces bar plots for counts of ref vs alt vs het allells for
particular rsID taxa combinations}
\usage{
logitPlotSnpTaxa(
  microbeAbund,
  SnpFile,
  selectmicrobe = NULL,
  rsID,
  ref = NULL,
  alt = NULL,
  het = NULL,
  color = NULL,
  cutoff = NULL
)
}
\arguments{
\item{microbeAbund}{original microbe abundance file (colnames microbe, rownames= sample IDs)}

\item{SnpFile}{original snp file with (0,1,2 values for ref, het, alt genotypes), colnames
SNP names, rownames, sample IDs.}

\item{selectmicrobe}{name of the microbe of interest (for example individual significant microbes
associate with a snp).}

\item{rsID}{name of the snp of interest (for example individual significant snps associated with
a microbe)}

\item{ref}{the name of reference genotype for example "GG"}

\item{alt}{the name of snp (variant) genotype for example "AA"}

\item{het}{the name of hetrozygote genotype for example "GA"}

\item{color}{the default is NULL and the color is set to c("#ffaa1e", "#87365b").}

\item{cutoff}{cutoff at which we call microbe present or absent}
}
\value{
A bar ggplot comparing the counts of ref vs alt vs het genotype
}
\description{
This function creates a dataframe output produces a formatted dataframe prepared.
}
\examples{
data(microbeAbund)
data(SnpFile)
x <- logitPlotSnpTaxa(microbeAbund, SnpFile,
  selectmicrobe = "Neisseria", rsID = "chr2.241072116_A",
  ref = NULL, alt = NULL, het = NULL, color = NULL, cutoff = NULL
)
}
\keyword{barplot}
\keyword{logitplot}
