% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/sig_heatmap-methods.R
\name{sig_heatmap}
\alias{sig_heatmap}
\alias{sig_heatmap,matrix,character,vector,missing-method}
\alias{sig_heatmap,matrix,character,vector,vector-method}
\alias{sig_heatmap,matrix,list,vector,missing-method}
\alias{sig_heatmap,Matrix,ANY,vector,ANY-method}
\alias{sig_heatmap,data.frame,ANY,vector,ANY-method}
\alias{sig_heatmap,DGEList,ANY,character,ANY-method}
\alias{sig_heatmap,ExpressionSet,ANY,character,ANY-method}
\alias{sig_heatmap,Seurat,ANY,character,ANY-method}
\alias{sig_heatmap,SummarizedExperiment,ANY,character,ANY-method}
\alias{sig_heatmap,list,ANY,character,ANY-method}
\title{Heatmap original markers and screened signature}
\usage{
sig_heatmap(
  data,
  sigs,
  group_col,
  markers,
  scale = c("none", "row", "column"),
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{matrix,character,vector,missing}(
  data,
  sigs,
  group_col,
  markers,
  scale = c("none", "row", "column"),
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{matrix,character,vector,vector}(
  data,
  sigs,
  group_col,
  markers,
  scale = c("none", "row", "column"),
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{matrix,list,vector,missing}(
  data,
  sigs,
  group_col,
  markers,
  scale = c("none", "row", "column"),
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{Matrix,ANY,vector,ANY}(
  data,
  sigs,
  group_col,
  markers,
  scale = c("none", "row", "column"),
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{data.frame,ANY,vector,ANY}(
  data,
  sigs,
  group_col,
  markers,
  scale = c("none", "row", "column"),
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{DGEList,ANY,character,ANY}(
  data,
  sigs,
  group_col,
  markers,
  scale = "none",
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{ExpressionSet,ANY,character,ANY}(
  data,
  sigs,
  group_col,
  markers,
  scale = c("none", "row", "column"),
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{Seurat,ANY,character,ANY}(
  data,
  sigs,
  group_col,
  markers,
  scale = "none",
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{SummarizedExperiment,ANY,character,ANY}(
  data,
  sigs,
  group_col,
  markers,
  scale = "none",
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)

\S4method{sig_heatmap}{list,ANY,character,ANY}(
  data,
  sigs,
  group_col,
  markers,
  scale = "none",
  gene_id = "SYMBOL",
  ranks_plot = FALSE,
  slot = "counts",
  ...
)
}
\arguments{
\item{data}{expression data, can be matrix, DGEList, eSet, seurat, sce...}

\item{sigs}{a vector of signature (Symbols) or a list of signatures}

\item{group_col}{character or vector, specify the column name to compare in coldata}

\item{markers}{a vector of gene names, listed the gene symbols of original
markers pool}

\item{scale}{could be one of 'none' (default), 'row' or 'column'}

\item{gene_id}{character, indicate the ID type of rowname of expression data's ,
could be one of 'ENSEMBL', 'SYMBOL', ... default 'SYMBOL'}

\item{ranks_plot}{logical, if to use ranks instead of expression of genes to
draw heatmap}

\item{slot}{character, indicate which slot used as expression, optional}

\item{...}{params for \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}}
}
\value{
patchwork object of heatmap
}
\description{
Compare the heatmap before and after screening.
}
\examples{
data("im_data_6", "nk_markers")
sig_heatmap(
  data = im_data_6, sigs = nk_markers$HGNC_Symbol[1:10],
  group_col = "celltype:ch1",
  gene_id = "ENSEMBL"
)

}
