% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/sig_rankdensity_plot-methods.R
\name{sig_rankdensity_plot}
\alias{sig_rankdensity_plot}
\alias{sig_rankdensity_plot,matrix,vector,vector-method}
\alias{sig_rankdensity_plot,Matrix,vector,vector-method}
\alias{sig_rankdensity_plot,data.frame,vector,vector-method}
\alias{sig_rankdensity_plot,DGEList,vector,character-method}
\alias{sig_rankdensity_plot,ExpressionSet,vector,character-method}
\alias{sig_rankdensity_plot,Seurat,vector,character-method}
\alias{sig_rankdensity_plot,SummarizedExperiment,vector,character-method}
\alias{sig_rankdensity_plot,list,vector,character-method}
\title{Plot rank density}
\usage{
sig_rankdensity_plot(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  slot = "counts",
  gene_id = "SYMBOL"
)

\S4method{sig_rankdensity_plot}{matrix,vector,vector}(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  gene_id = "SYMBOL"
)

\S4method{sig_rankdensity_plot}{Matrix,vector,vector}(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  gene_id = "SYMBOL"
)

\S4method{sig_rankdensity_plot}{data.frame,vector,vector}(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  gene_id = "SYMBOL"
)

\S4method{sig_rankdensity_plot}{DGEList,vector,character}(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  slot = "counts",
  gene_id = "SYMBOL"
)

\S4method{sig_rankdensity_plot}{ExpressionSet,vector,character}(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  gene_id = "SYMBOL"
)

\S4method{sig_rankdensity_plot}{Seurat,vector,character}(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  slot = "counts",
  gene_id = "SYMBOL"
)

\S4method{sig_rankdensity_plot}{SummarizedExperiment,vector,character}(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  slot = "counts",
  gene_id = "SYMBOL"
)

\S4method{sig_rankdensity_plot}{list,vector,character}(
  data,
  sigs,
  group_col,
  aggregate = FALSE,
  slot = "counts",
  gene_id = "SYMBOL"
)
}
\arguments{
\item{data}{expression data, can be matrix, DGEList, eSet, seurat, sce...}

\item{sigs}{a vector of signature (Symbols)}

\item{group_col}{character or vector, specify the column name to compare in coldata}

\item{aggregate}{logical, if to aggregate expression according to \code{group_col},
default FALSE}

\item{slot}{character, indicate which slot used as expression, optional}

\item{gene_id}{character, indicate the ID type of rowname of expression data's ,
could be one of 'ENSEMBL', 'SYMBOL', ... default 'SYMBOL'}
}
\value{
ggplot or patchwork
}
\description{
Show the rank density of given signature in the given comparison.
}
\examples{
data("im_data_6", "nk_markers")
sig_rankdensity_plot(
  data = im_data_6, sigs = nk_markers$HGNC_Symbol[1:10],
  group_col = "celltype:ch1", gene_id = "ENSEMBL"
)

}
