% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{subvert}
\alias{subvert}
\title{Vertices with an attribute}
\usage{
subvert(net, attr, values, affirmative = TRUE)
}
\arguments{
\item{net}{An igraph network.}

\item{attr}{An attribute of the vertices.}

\item{values}{Possible values of \code{attr}}

\item{affirmative}{Logical. States if a condition must be its affirmation 
(e.g. all nodes with gene name "X"), or its negation (all nodes not with gene
name "X").}
}
\value{
The vertices with attribute equal to any of the values in
\code{values}.
}
\description{
Returns the nodes matching some condition.
}
\examples{
gi <- get_GI_network(minigwas, snpMapping = minisnpMapping, ppi = minippi)
martini:::subvert(gi, "gene", "A")
martini:::subvert(gi, "name", c("1A1", "1A3"))
}
