\name{image}
\docType{methods}
\alias{image,marrayRaw-method}
\alias{image,marrayNorm-method}


%- Also NEED an `\alias' for EACH other topic documented here.
\title{Color image for cDNA microarray spot statistics}
\description{
  We encourage users calling "image" rather than "maImage".  The name of
  the arguments are change slightly.
  The function \code{image} creates spatial images of shades of gray or
  colors that correspond to the values of a statistic for each spot on the
  array. The statistic can be the intensity log-ratio M, a spot quality
  measure (e.g. spot size or shape), or a test statistic. This function
  can be used to explore whether there are any spatial effects in the
  data, for example, print-tip or cover-slip effects.  
}
\usage{
\S4method{image}{marrayRaw}(x, xvar = "maM", subset = TRUE, col, contours=FALSE,  bar = TRUE, overlay=NULL, ol.col=1, colorinfo=FALSE, ...)
\S4method{image}{marrayNorm}(x, xvar = "maM", subset = TRUE, col, contours=FALSE,  bar = TRUE, overlay=NULL, ol.col=1, colorinfo=FALSE, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{Microarray object of class \code{"\link{marrayRaw}"},
    \code{"\link{marrayNorm}"}}
  \item{xvar}{Name of accessor function for the spot statistic of interest,
    typically a slot name for the microarray object \code{x}, such as
    \code{maM}.} 
  \item{subset}{A "logical" or "numeric" vector indicating the subset of
    spots to display on the image.} 
  \item{col}{List of colors such as that generated by rainbow, heat.colors,
    topo.colors, terrain.colors, or similar
    functions. In addition to these color palette functions, a new
    function \code{\link{maPalette}} was defined to generate color
    palettes from user supplied low, middle, and high color values. } 
  \item{contours}{If \code{contours=TRUE}, contours are plotted, otherwise they are not shown.}
  \item{bar}{If \code{bar=TRUE}, a calibration color bar is shown to the right of the image.}
  \item{overlay}{A logical vector of spots to be highlighted on the image plots.}
  \item{ol.col}{Color of the overlay spots.}
  \item{colorinfo}{A logical value indicating whether the function
    should return the color scale information.} 
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}
\details{
 This function calls the general function \code{\link{maImage.func}},
 which is not specific to microarray data. If there are more than one
 array in the batch, the plot is done for the first array, by
 default. Default color palettes were set for different types of spot
 statistics using the \code{\link{maPalette}} function. When
 \code{x=c("maM", "maMloc", "maMscale")}, a green-to-red color palette
 is used. When \code{x=c("maGb", "maGf", "maLG")}, a white-to-green
 color palette is used. When \code{x=c("maRb", "maRf", "maLR")}, a
 white-to-red color palette is used. The user has the option to
 overwrite these parameters at any point.  
}

\value{
  If \code{colorinfo} is set to TRUE, the following list with elements will be returned.
  \item{x.col}{vector of colors to be used for calibration color bar.}
  \item{x.bar}{vector of values to be used for calibration color bar.}
  \item{summary}{six number summary of the spot statistics, from the function \code{\link{summary}}.}

}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages
  for exploratory analysis and normalization of cDNA microarray data. In
  G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors,
  \emph{The Analysis of Gene Expression Data: Methods and Software},
  Springer, New York. 
}

\author{Jean Yang and Sandrine Dudoit}

\seealso{\code{\link{maImage}}, \code{\link{maImage.func}},
  \code{\link{maColorBar}}, \code{\link{maPalette}}}

\examples{
# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Microarray color palettes
Gcol <- maPalette(low = "white", high = "green", k = 50)
Rcol <- maPalette(low = "white", high = "red", k = 50)
BYcol <- maPalette(low = "blue", mid="gray", high = "yellow", k = 50)

# Color images of green and red background and foreground intensities
##image(swirl[, 2], xvar ="maGb")
##image(swirl[, 2], xvar ="maGf", subset = TRUE, col = Gcol, contours = FALSE, bar = TRUE, main="Swirl array 93")
##image(swirl[, 1], xvar ="maRb", contour=TRUE)
##image(swirl[, 4], xvar ="maRf", bar=FALSE)

# Color images of pre-normalization intensity log-ratios
##image(swirl[, 1])

# Color images with overlay spots
##image(swirl[, 3], xvar = "maA", overlay = maTop(maA(swirl[, 3]), h = 0.1, l = 0.1), bar = TRUE, main = "Image of A values with \% 10 tails highlighted") 

# Color image of print-tip-group
##image(swirl[, 1],xvar = "maPrintTip")

}
\keyword{hplot}% at least one, from doc/KEYWORDS

