% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateScores_ssGSEA.R
\name{CalculateScores_ssGSEA_unidirectional}
\alias{CalculateScores_ssGSEA_unidirectional}
\title{Calculate ssGSEA Scores for Unidirectional Gene Signatures}
\usage{
CalculateScores_ssGSEA_unidirectional(data, signature)
}
\arguments{
\item{data}{A data frame of normalized (non-transformed) counts where rows are
genes and columns are samples.}

\item{signature}{A vector of gene names representing a unidirectional gene
signature.}
}
\value{
A data frame containing:
\itemize{
\item \code{sample}: Sample name.
\item \code{score}: ssGSEA enrichment score for the gene signature.
}
}
\description{
Computes single-sample Gene Set Enrichment Analysis (ssGSEA) scores for each
sample using a unidirectional gene signature.
}
\examples{
\dontrun{
# Example dataset with 5 genes (rows) and 3 samples (columns)
set.seed(123)
data <- matrix(runif(15, 1, 100), nrow = 5, ncol = 3)
rownames(data) <- paste0("Gene_", 1:5)
colnames(data) <- paste0("Sample_", 1:3)

# Define a unidirectional gene signature
signature <- c("Gene_1", "Gene_3", "Gene_5")

# Compute scores
scores <- CalculateScores_ssGSEA_unidirectional(data, signature = signature)
print(scores)
}
}
\keyword{internal}
