% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_identification.R
\name{find_delta}
\alias{find_delta}
\title{Find delta motifs}
\usage{
find_delta(
  edgelist = NULL,
  paralogs = NULL,
  edgelist_ppi = NULL,
  lambda_vec = NULL,
  count_only = FALSE
)
}
\arguments{
\item{edgelist}{A 2-column data frame with regulators in column 1 and
targets in column 2. It can be ignored if you give lambda motifs
to parameter \strong{lambda_vec} (recommended).}

\item{paralogs}{A 2-column data frame with gene IDs for each paralog
in the paralog pair. It can be ignored if you give lambda motifs
to parameter \strong{lambda_vec} (recommended).}

\item{edgelist_ppi}{A 2-column data frame with IDs of genes that encode
each protein in the interacting pair.}

\item{lambda_vec}{A character of lambda motifs as returned
by \code{find_lambda()}. If this is NULL, this function will find lambda
motifs from \strong{edgelist} and \strong{paralogs} first. Passing
previously identified lambda motifs will make this function much faster.}

\item{count_only}{Logical indicating whether the function should return
only motif counts as a numeric scalar. If FALSE, it will return
a character vector of motifs. Default: FALSE.}
}
\value{
A character vector with lambda motifs represented
in the format \strong{target1<-regulator->target2}.
}
\description{
Find delta motifs
}
\examples{
data(gma_grn)
data(gma_paralogs)
data(gma_ppi)
edgelist <- gma_grn[500:1000, 1:2] # reducing for test purposes
edgelist <- gma_grn[1:10000, 1:2]
paralogs <- gma_paralogs[gma_paralogs$type == "WGD", 1:2]
edgelist_ppi <- gma_ppi
lambda_vec <- find_lambda(edgelist, paralogs)
motifs <- find_delta(edgelist_ppi = edgelist_ppi, lambda_vec = lambda_vec)
}
