% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls.R
\name{calculate_Z}
\alias{calculate_Z}
\title{Calculate Z-score for motif frequencies}
\usage{
calculate_Z(observed = NULL, nulls = NULL)
}
\arguments{
\item{observed}{A list of observed motif frequencies for each motif type.
List elements must be named 'lambda', 'bifan', 'V', 'PPI_V', and
'delta' (not necessarily in that order).}

\item{nulls}{A list of null distributions for each motif type
as returned by \code{generate_nulls}.}
}
\value{
A numeric vector with the Z-score for each motif type.
}
\description{
Calculate Z-score for motif frequencies
}
\examples{
# Simulating it for test purposes
null <- rnorm(1000, mean = 5, sd = 1)
nulls <- list(
    lambda = null, V = null, PPI_V = null, delta = null, bifan = null
)
observed <- list(lambda = 7, bifan = 13, delta = 9, V = 5, PPI_V = 10)
z <- calculate_Z(observed, nulls)
# Check for motif enrichment (Z > 5)
z[which(z > 5)]
}
