% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/titv.R
\name{titv}
\alias{titv}
\title{Classifies SNPs into transitions and transversions}
\usage{
titv(maf, useSyn = FALSE, plot = TRUE, file = NULL)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{useSyn}{Logical. Whether to include synonymous variants in analysis. Defaults to FALSE.}

\item{plot}{plots a titv fractions. default TRUE.}

\item{file}{basename for output file name. If given writes summaries to output file. Default NULL.}
}
\value{
list of \code{data.frame}s with Transitions and Transversions summary.
}
\description{
takes output generated by read.maf and classifies Single Nucleotide Variants into Transitions and Transversions.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
laml.titv = titv(maf = laml, useSyn = TRUE)

}
\seealso{
\code{\link{plotTiTv}}
}
