% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_swap.R
\name{sampleSwaps}
\alias{sampleSwaps}
\title{Identify sample swaps and similarities}
\usage{
sampleSwaps(
  bams = NULL,
  build = "hg19",
  prefix = NULL,
  add = TRUE,
  min_depth = 30,
  ncores = 4,
  ...
)
}
\arguments{
\item{bams}{Input bam files. Required.}

\item{build}{reference genome build. Default "hg19". Can be hg19 or hg38}

\item{prefix}{Prefix to add or remove from contig names in SNP file. If BAM files are aligned GRCh37/38 genome, use prefix `chr` to `add`}

\item{add}{If prefix is used, default is to add prefix to contig names in SNP file. If FALSE prefix will be removed from contig names.}

\item{min_depth}{Minimum read depth for a SNP to be considered. Default 30.}

\item{ncores}{Default 4. Each BAM file will be launched on a separate thread. Works only on Unix and macOS.}

\item{...}{Additional arguments passed to \code{\link{bamreadcounts}}}
}
\value{
a list with results summarized
}
\description{
Given a list BAM files, the function genotypes known SNPs and identifies potentially related samples. For the source of SNPs, see reference
}
\references{
Westphal, M., Frankhouser, D., Sonzone, C. et al. SMaSH: Sample matching using SNPs in humans. BMC Genomics 20, 1001 (2019). https://doi.org/10.1186/s12864-019-6332-7
}
