% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncationAssignment.R
\name{truncationAssignment}
\alias{truncationAssignment}
\title{truncationAssignment for assigning the truncation read counts to the
    GRanges object with single nucleotide peaks}
\usage{
truncationAssignment(object, bw_positive, bw_negative, sampleName = "")
}
\arguments{
\item{object}{A GRanges object which should contains all the single
nucleotide peaks of miCLIP2 experiment.}

\item{bw_positive}{A path to the bigWig file of truncation read counts
at the positive strand that output from the preprocess in the m6Aboost
pipeline.}

\item{bw_negative}{A path to the bigWig file of truncation read counts
at the negative strand that output from the preprocess in the m6Aboost
pipeline.}

\item{sampleName}{The column name that user would like to use for indicating
the name of the sample.}
}
\value{
A GRanges object with the truncation read counts.
}
\description{
An function for assigning the truncation read counts from
    bigWig to the GRanges peaks.
}
\examples{
if (.Platform$OS.type != "windows") {
    testpath <- system.file("extdata", package = "m6Aboost")
    test <- readRDS(file.path(testpath, "test.rds"))
    truncationBw_p <- file.path(testpath, "truncation_positive.bw")
    truncationBw_n <- file.path(testpath, "truncation_negative.bw")
    test <- truncationAssignment(test, bw_positive=truncationBw_p,
        bw_negative=truncationBw_n, sampleName = "WT1")

}

}
\author{
You Zhou
}
