% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/loci2pathResult-methods.R
\docType{methods}
\name{getHeatmap}
\alias{getHeatmap}
\alias{getHeatmap,loci2pathResult-method}
\title{Generate heatmap of enrichment matrix from query result}
\usage{
getHeatmap(res, ...)

\S4method{getHeatmap}{loci2pathResult}(res, main = "",
  test.method = c("gene", "eqtl", "glm"), filter.quantile = 0.5,
  max.ptw.gene = 5000)
}
\arguments{
\item{res}{query result from function query.egset.list()}

\item{\dots}{additional params}

\item{main}{title of the heatmap, default is ""}

\item{test.method}{Choose which enrichment test should be used to retrive
p-values from. Options include:"gene"(default, gene-based fisher's exact 
test),"eqtl" (eqtl based fisher's exact test), "glm" (ordered query)}

\item{filter.quantile}{Filter option; choose the max quantile of all
p-values being kept in the matrix; default is 0.5, which means p-values
larger than median p-values are discarded}

\item{max.ptw.gene}{Filter option; minimum number of genes in a pathway;
default is 5000 (pathway with >5000 genes are not included in the matrix)}
}
\value{
\item{pathways}{frequent pathways}
\item{tissues}{frequent tissues}
}
\description{
This function generate the enrichment heatmap using pheatmap package.
}
\examples{
result <- query(query.gr=query.gr, 
  loci=eset.list, path=biocarta)
getHeatmap(result)
}
\keyword{heatmap}
