% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.R
\name{update_molecule_names}
\alias{update_molecule_names}
\title{Rename molecules in a dataset.}
\usage{
update_molecule_names(data, old, new)
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{old}{A character vector of the molecule names to be renamed.}

\item{new}{A character vector of the new molecule names.}
}
\value{
A LipidomicsExperiment object with molecules name and annotation
updated.
}
\description{
This function enables users to rename selected molecules in the dataset,
so that they can be parsed correctly by \code{lipidr} or modify the lipid class.
\code{lipidr} automatically updates the annotation for the renamed molecules.
}
\examples{
data(data_normalized)
old_names <- rowData(data_normalized)$Molecule
# replace PCO with plasmenylPC
new_names <- sub("^LPE", "LysoPE", old_names)
update_molecule_names(data_normalized, old_names, new_names)
}
