% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readfiles.R
\name{read_skyline}
\alias{read_skyline}
\title{Read Skyline exported files}
\usage{
read_skyline(files)
}
\arguments{
\item{files}{Character vector with filepaths to
Skyline exported files in CSV format.}
}
\value{
LipidomicsExperiment object.
}
\description{
Read Skyline exported files
}
\examples{
datadir <- system.file("extdata", package = "lipidr")

# all csv files
filelist <- list.files(datadir, "data.csv", full.names = TRUE)
d <- read_skyline(filelist)

# View automatically generated lipid annotations
rowData(d)
}
