% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_trend}
\alias{plot_trend}
\title{Plot a regulation trend line  between logFC and chain annotation}
\usage{
plot_trend(de_results, annotation = c("length", "unsat"))
}
\arguments{
\item{de_results}{Output of \url{de_analysis}.}

\item{annotation}{Whether to fit trend line against chain \code{length} or \code{unsat}.}
}
\value{
A ggplot object.
}
\description{
Fit and plot a regression line of (log2) fold changes and total chain
lengths or unsaturations. If multiple comparisons are included, one
regression is plotted for each.
}
\examples{
data(data_normalized)
de_results <- de_analysis(
  data_normalized,
  HighFat_water - NormalDiet_water,
  NormalDiet_DCA - NormalDiet_water,
  measure = "Area"
)
plot_trend(de_results, "length")
}
