% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotBaits}
\alias{plotBaits}
\title{Plot Baits}
\usage{
plotBaits(
  linkset,
  scoreCol = "score",
  countCol = "count",
  n = 4,
  baits = NULL,
  plotBaitNames = TRUE,
  plevel1 = 5,
  plevel2 = 3,
  outfile = NULL,
  width = 20,
  height = 20,
  extend.base = 1e+06,
  bgCol = "black",
  lev2Col = "blue",
  lev1Col = "red",
  ...
)
}
\arguments{
\item{linkset}{A linkSet object}

\item{scoreCol}{Column name containing scores for coloring points}

\item{countCol}{Column name containing counts for y-axis values}

\item{n}{Number of random baits to plot if baits parameter is NULL}

\item{baits}{Vector of specific baits to plot. If NULL, n random baits are selected}

\item{plotBaitNames}{Logical indicating whether to show bait names in plot titles}

\item{plevel1}{Upper threshold for score coloring (red)}

\item{plevel2}{Lower threshold for score coloring (blue)}

\item{outfile}{Output file path. If NULL, plot is displayed rather than saved}

\item{width}{Width of output plot in inches}

\item{height}{Height of output plot in inches}

\item{extend.base}{Base pairs to extend view range on either side of bait}

\item{bgCol}{Color for points below plevel2 threshold}

\item{lev2Col}{Color for points between plevel2 and plevel1 thresholds}

\item{lev1Col}{Color for points above plevel1 threshold}

\item{...}{Additional plotting parameters}
}
\value{
A ggplot object
}
\description{
Plot baits in a linkSet object
}
\examples{
# Create example linkSet object
library(GenomicRanges)
gr1 <- GRanges(seqnames = c("chr1", "chr1", "chr2"),
               ranges = IRanges(start = c(1000, 2000, 3000), width = 100),
               strand = "+", symbol = c("Gene1", "Gene2", "Gene3"))
gr2 <- GRanges(seqnames = c("chr1", "chr2", "chr2"),
               ranges = IRanges(start = c(5000, 6000, 7000), width = 100),
               strand = "+")
linkset_obj <- linkSet(gr1, gr2, specificCol = "symbol")

# Add score and count metadata for plotting
mcols(linkset_obj)$score <- c(2.5, 4.2, 6.1)
mcols(linkset_obj)$count <- c(10, 25, 15)

# Plot baits (requires annotated bait regions)
\donttest{
# Note: This requires regionsBait to be annotated
# plotBaits(linkset_obj, n = 2)
}
}
