% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRange_method.R
\name{trim,linkSet-method}
\alias{trim,linkSet-method}
\alias{trim}
\alias{resize,linkSet-method}
\alias{resize}
\alias{resizeRegions,linkSet-method}
\alias{resizeRegions}
\alias{narrow,linkSet-method}
\alias{narrow}
\alias{narrowRegions,linkSet-method}
\alias{narrowRegions}
\alias{shift,linkSet-method}
\alias{shift}
\alias{shiftRegions,linkSet-method}
\alias{shiftRegions}
\alias{flank,linkSet-method}
\alias{flank}
\alias{flankRegions,linkSet-method}
\alias{flankRegions}
\alias{promoters,linkSet-method}
\alias{promoters}
\alias{promoterRegions,linkSet-method}
\alias{promoterRegions}
\alias{width,linkSet-method}
\alias{width}
\alias{reduce,linkSet-method}
\alias{reduce}
\title{linkSet-GRange-Methods}
\usage{
\S4method{trim}{linkSet}(x, use.names = TRUE, ...)

\S4method{resize}{linkSet}(x, width, fix = "start", use.names = TRUE, ...)

\S4method{resizeRegions}{linkSet}(
  x,
  width = 1000,
  fix = "start",
  use.names = TRUE,
  region = "both",
  ...
)

\S4method{narrow}{linkSet}(x, start = NA, end = NA, width = NA, use.names = TRUE)

\S4method{narrowRegions}{linkSet}(
  x,
  start = NA,
  end = NA,
  width = NA,
  use.names = TRUE,
  region = "both"
)

\S4method{shift}{linkSet}(x, shift = 0L, use.names = TRUE)

\S4method{shiftRegions}{linkSet}(x, shift = 0L, use.names = TRUE, region = "both")

\S4method{flank}{linkSet}(
  x,
  width,
  start = TRUE,
  both = FALSE,
  use.names = TRUE,
  ignore.strand = FALSE
)

\S4method{flankRegions}{linkSet}(
  x,
  width,
  start = TRUE,
  both = FALSE,
  use.names = TRUE,
  ignore.strand = FALSE,
  region = "both"
)

\S4method{promoters}{linkSet}(x, upstream = 2000, downstream = 200, use.names = TRUE)

\S4method{promoterRegions}{linkSet}(
  x,
  upstream = 2000,
  downstream = 200,
  use.names = TRUE,
  region = "both"
)

\S4method{width}{linkSet}(x)

\S4method{reduce}{linkSet}(x, drop.empty.ranges = FALSE, ...)
}
\arguments{
\item{x}{A linkSet object}

\item{use.names}{A logical indicating whether to use names}

\item{...}{Additional arguments passed to the GenomicRanges trim method}

\item{width}{The desired width of the output ranges}

\item{fix}{The anchor point for resizing operations ("start", "end", or "center")}

\item{region}{Which regions to modify ("both", "bait", or "oe")}

\item{start, end}{The desired start and end coordinates for narrowing}

\item{shift}{The number of positions to shift}

\item{both}{Whether to get flanking regions on both sides}

\item{ignore.strand}{
    \code{TRUE} or \code{FALSE}. Whether the strand of the input ranges
    should be ignored or not. See details below.
  }

\item{upstream, downstream}{Number of bases upstream/downstream for promoter regions}

\item{drop.empty.ranges}{Whether to drop empty ranges when reducing}
}
\value{
A linkSet object
}
\description{
This man page documents intra range transformations of a \linkS4class{linkSet} object.
}
\examples{
data(linkExample)
resize_bait <- resizeRegions(linkExample, width = 75, fix = "start", region = "bait")
resize_bait

narrow_bait <- narrowRegions(linkExample, start = 1, width = 5, region = "bait")
narrow_bait

shift_oe <- shiftRegions(linkExample, shift = 10, region = "oe")
shift_oe

flank_bait <- flankRegions(linkExample, width = 100, start = TRUE, both = FALSE, 
                          use.names = TRUE, ignore.strand = FALSE, region = "bait")
flank_bait

width(linkExample)

}
\author{
Gilbert Han
}
