% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/formatConverter.R
\name{exportWashU}
\alias{exportWashU}
\alias{exportWashU,linkSet-method}
\title{Export linkSet to WashU browser format}
\usage{
exportWashU(x, outfile)

\S4method{exportWashU}{linkSet}(x, outfile)
}
\arguments{
\item{x}{A linkSet object}

\item{outfile}{Output file path}
}
\value{
None. The function writes to the specified file.
}
\description{
Exports a linkSet object to a tab-delimited format compatible with the WashU genome browser
}
\details{
Export linkSet to WashU Format
}
\examples{
data(linkExample)
tmpfile <- tempfile(fileext = ".txt")
exportWashU(linkExample, tmpfile)
cat(readLines(tmpfile), sep = "\n")
}
