% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineagespot.R
\name{lineagespot}
\alias{lineagespot}
\title{lineagespot}
\usage{
lineagespot(
  vcf_fls = NULL,
  vcf_folder = NULL,
  gff3_path = NULL,
  ref_folder = NULL,
  voc = c("B.1.617.2", "B.1.1.7", "B.1.351", "P.1"),
  AF_threshold = 0.8
)
}
\arguments{
\item{vcf_fls}{A character vector of paths to VCF files}

\item{vcf_folder}{A path to a folder containing all VCF files
that will be integrated into a single table}

\item{gff3_path}{Path to GFF3 file containing SARS-CoV-2 gene coordinates.}

\item{ref_folder}{A path to a folder containing lineage reports}

\item{voc}{A character vector containing the names of the lineages of interest}

\item{AF_threshold}{A parameter indicating the AF threshold for identifying variants per sample}
}
\value{
A list of three elements;
\itemize{
\item Variants' table; A data table containing all variants that are
included in the input VCF files
\item Lineage hits; A data table containing identified hits between the input
variants and outbreak.info's lineage reports
\item Lineage report; A data table with computed metrics about
the prevalence of the lineage of interest per sample.
}
}
\description{
Identify SARS-CoV-2 related mutations based on a single (or a list) of
variant(s) file(s)
}
\examples{

results <- lineagespot(
    vcf_folder = system.file("extdata", "vcf-files",
        package = "lineagespot"
    ),
    gff3_path = system.file("extdata",
        "NC_045512.2_annot.gff3",
        package = "lineagespot"
    ),
    ref_folder = system.file("extdata", "ref",
        package = "lineagespot"
    )
)

head(results$lineage.report)

}
