% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rowNames2RowData}
\alias{rowNames2RowData}
\title{RowNames to RowData}
\usage{
rowNames2RowData(x)
}
\arguments{
\item{x}{A
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}
with the features taxonomy in the rownames.}
}
\value{
The same
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}
with the taxonomy now in the rowData.
}
\description{
\code{rowNames2RowData} transforms the taxonomy stored in the row names to
the rowData in a
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}.
}
\examples{

data("zeller14")

## Keep only "CRC" and "control" (dichotomous variable)
z14 <- zeller14[, zeller14$study_condition \%in\% c("control", "CRC")]

## Get terminal nodes
tn <- get_terminal_nodes(rownames(z14))
z14_tn <- z14[tn, ]

## Normalize to relative abundance (also known as Total Sum Scaling)
z14_tn_ra <- relativeAb(z14_tn)

## Add the taxonomy to the rowData
input_se <- rowNames2RowData(z14_tn_ra)

}
