% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefserClades.R
\name{lefserClades}
\alias{lefserClades}
\title{Run lefser at different clades}
\usage{
lefserClades(relab, ...)
}
\arguments{
\item{relab}{A
(Tree) \link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}
with full taxonomy in the rowData @param ... Arguments passed to the
\code{lefser} function.}

\item{\ldots}{Additional arguments passed to \code{lefser}}
}
\value{
An object of class 'lefser_df_clades', "lefser_df", and 'data.frame'.
}
\description{
\code{lefesrCaldes} Agglomerates the features abundance at different
taxonomic ranks using \link[mia:agglomerate-methods]{mia::splitByRanks}
and performs lefser at each rank. The analysis is run at the species,
genus, family, order, class, and phylum levels.
}
\details{
When running \code{lefserClades}, all features with NAs in the rowData will
be dropped. This is to avoid creating artificial clades with NAs.
}
\examples{

data("zeller14")
z14 <- zeller14[, zeller14$study_condition != "adenoma"]
tn <- get_terminal_nodes(rownames(z14))
z14tn <- z14[tn, ]
z14tn_ra <- relativeAb(z14tn)
z14_input <- rowNames2RowData(z14tn_ra)

resCl <- lefserClades(relab = z14_input, classCol = "study_condition")

}
