% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefser.R
\name{lefser}
\alias{lefser}
\title{R implementation of the LEfSe method}
\usage{
lefser(
  relab,
  kruskal.threshold = 0.05,
  wilcox.threshold = 0.05,
  lda.threshold = 2,
  classCol = "CLASS",
  subclassCol = NULL,
  assay = 1L,
  trim.names = FALSE,
  checkAbundances = TRUE,
  method = "none",
  ...
)
}
\arguments{
\item{relab}{A \link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class}
with relative abundances in the assay}

\item{kruskal.threshold}{numeric(1) The p-value for the Kruskal-Wallis Rank
Sum Test (default 0.05). If multiple hypothesis testing is performed, this
threshold is applied to corrected p-values.}

\item{wilcox.threshold}{numeric(1) The p-value for the Wilcoxon Rank-Sum Test
when 'subclassCol' is present (default 0.05). If multiple hypothesis testing is
performed, this threshold is applied to corrected p-values.}

\item{lda.threshold}{numeric(1) The effect size threshold (default 2.0).}

\item{classCol}{character(1) Column name in \code{colData(relab)} indicating
class, usually a factor with two levels (e.g., \code{c("cases", "controls")};
default "CLASS").}

\item{subclassCol}{character(1) Optional column name in \code{colData(relab)}
indicating the subclasses, usually a factor with two levels (e.g.,
\code{c("adult", "senior")}; default NULL), but can be more than two levels.}

\item{assay}{The i-th assay matrix in the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
('relab'; #' default 1).}

\item{trim.names}{Default is \code{FALSE}. If \code{TRUE}, this function extracts
the most specific taxonomic rank of organism.}

\item{checkAbundances}{\code{logical(1)} Whether to check if the assay data in the
\code{relab} input are relative abundances or counts. If counts are found, a
warning will be emitted (default \code{TRUE}).}

\item{method}{Default is "none" as in the original LEfSe implementation.
Character string of length one, passed on to \link[stats]{p.adjust} to set
option for multiple testing. For multiple pairwise comparisons, each comparison
is adjusted separately. Options are "holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr" (synonym for "BH"), and "none".}

\item{\ldots}{Additional inputs to lower level functions (not used).}
}
\value{
The function returns a \code{data.frame} with two columns, which are
names of features and their LDA scores.
}
\description{
Perform a LEfSe analysis: the function carries out differential analysis
between two sample classes for multiple features and uses linear discriminant analysis
to establish their effect sizes. Subclass information for each class can be incorporated
into the analysis (see examples). Features with large differences between two sample classes
are identified as biomarkers.
}
\details{
The LEfSe method expects relative abundances in the \code{expr} input. A warning
will be emitted if the column sums do not result in 1. Use the \code{relativeAb}
helper function to convert the data in the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
to relative abundances. The \code{checkAbundances} argument enables checking the
data for presence of relative abundances and can be turned off by setting
the argument to \code{FALSE}.
}
\examples{

    data(zeller14)
    zeller14 <- zeller14[, zeller14$study_condition != "adenoma"]
    tn <- get_terminal_nodes(rownames(zeller14))
    zeller14tn <- zeller14[tn,]
    zeller14tn_ra <- relativeAb(zeller14tn)

    # (1) Using classes only
    res_class <- lefser(zeller14tn_ra,
                        classCol = "study_condition")
    # (2) Using classes and sub-classes
    res_subclass <- lefser(zeller14tn_ra,
                        classCol = "study_condition",
                        subclassCol = "age_category")

}
