% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmvalcut.R
\name{km_val_cut}
\alias{km_val_cut}
\title{Validate stratification cutoffs on test data}
\usage{
km_val_cut(
  infile,
  obj,
  bfname,
  wdir = getwd(),
  min_uval = 50,
  psort = FALSE,
  wlabels = TRUE,
  wpdf = TRUE
)
}
\arguments{
\item{infile}{a character string (character vector of length 1) that
specifies the name of tab-delimited 
file with the table that contains features 
and a stratification threshold for each feature (this table is produced
by 'km_opt_scut', 'km_opt_pcut', 'km_qcut' or 'km_ucut').
The file with previously determined stratification thresholds must have
first two columns named as 'tracking_id' and 'CUTOFF'.
The 'tracking_id' column contains feature names, the 'CUTOFF' column
contains stratification threshold for each feature.}

\item{obj}{SummarizedExperiment object with test expression}

\item{bfname}{a character string (character vector of length 1) that
specifies the base name used to construct output files, which are 
created by adding\cr'_KM_val' and corresponding extension to 'bfname'.}

\item{wdir}{a character string (character vector of length 1) that
specifies the name of the working 
directory for the input/output files (defaults to the current R directory).}

\item{min_uval}{numeric value that specifies the minimal percentage of
unique values per feature.
Features that have less than 'min_uval' percent unique values are
excluded from the analysis.}

\item{psort}{logical value whether to sort the output table by p-values
in increasing order (default is FALSE).}

\item{wlabels}{logical value whether to write a CSV file with low/high
(below/above the cutoff) group sample labels (default is TRUE).}

\item{wpdf}{logical value whether to write a PDF file with plots
(default is TRUE).}
}
\value{
no return value
}
\description{
Creates Kaplan-Meier survival curves for a validation data set by using a
file with previously determined stratification cutoffs and performs the
log-rank tests.
}
\examples{

# Example with data files included in the package:

# Load training (fdat1) and validation (fdat2) gene expression data
# files and survival data file (sdat).
fdat1 <- system.file("extdata", "expression_data_1.txt", package = "kmcut")
fdat2 <- system.file("extdata", "expression_data_2.txt", package = "kmcut")
sdat <- system.file("extdata", "survival_data.txt", package = "kmcut")

# Create SummarizedExperiment object with training data
se1 <- create_se_object(efile = fdat1, sfile = sdat)

# Run 'km_qcut' on the training data to create a file
# with thresholds "training_data_KM_quant_50.txt".
km_qcut(obj = se1, bfname = "training_data", quant = 50, min_uval = 40)

# Create SummarizedExperiment object with test data
se2 <- create_se_object(efile = fdat2, sfile = sdat)

# Validate the thresholds from "training_data_KM_quant_50.txt" on
# test data in 'se2'.
km_val_cut(infile = "training_data_KM_quant_50.txt", obj = se2, 
           bfname = "test", wpdf = FALSE, min_uval = 40)

# This will create two output files in the current working directory:
# 1) Tab-delimited text file with the results:
# "test_KM_val.txt"
# 2) CSV file with low/high sample labels:
# "test_KM_val_labels.csv"
}
