% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractrows.R
\name{extract_rows}
\alias{extract_rows}
\title{Extract a sub-set of rows}
\usage{
extract_rows(fnamein, fids, fnameout, wdir = getwd())
}
\arguments{
\item{fnamein}{a character string (character vector of length 1) that
specifies the name of tab-delimited text file with the input data table.}

\item{fids}{a character string (character vector of length 1) that
specifies the name of text file with row ids (such as gene ids).
The file must contain one row id per line, without any trailing spaces or
any other additional symbols.}

\item{fnameout}{a character string (character vector of length 1) that
specifies the name of output file where the new data table will be saved.}

\item{wdir}{a character string (character vector of length 1) that
specifies the name of the working 
directory for the input/output files (defaults to the current R directory).}
}
\value{
no return value
}
\description{
Extract a sub-set of rows (such as a group of gene ids)
from a data table. All columns will be preserved.
}
\examples{

# Example with built-in data files:

# Load example gene expression data table for 2 genes
fdat <- system.file("extdata", "example_genes.txt", package = "kmcut")
# Load a list that contains one gene id (MYCN)
idlist <- system.file("extdata", "rowids.txt", package = "kmcut")
# Run the function
extract_rows(fnamein = fdat, fids = idlist,
             fnameout = "example_genes_subset.txt")

# This will create in the current working directory a tab-delimited text file
# "example_genes_subset.txt" with one row "MYCN".
}
