% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threads.R
\name{set_threads}
\alias{set_threads}
\title{Set the number of available threads}
\usage{
set_threads(n_threads)
}
\arguments{
\item{n_threads}{The number of threads to use}
}
\value{
None. Sets the \code{iscream.threads} option to the requested number of
threads if available
}
\description{
Sets the \code{"iscream.threads"} option to \code{n_threads}. To see how many threads
you have available see \code{?get_threads()}.
}
\details{
iscream uses OpenMP to parallelize certain functions. You can use
as many threads as are available to you on your system to varying degrees of
performance improvements. The \code{get_threads()} function uses
\code{parallelly::availableCores()} to report the number of available threads.
Although OpenMP can detect the number of available cores, on high
performance computers (HPCs) with resource allocating job schedulers like
SLURM, OpenMP may detect all available threads across the HPC and not limit
itself to the cores that were allocated to you by the scheduler. If your
system administrator has not set up any limits, this may result in your job
taking resources from other jobs. If there are limits, trying to use more
threads that those available will reduce iscream's performance. Job
schedulers will typically have an environment variable (e.g.
\code{SLURM_CPUS_ON_NODE} with SLURM) that gives you the actual number of
available cores. Further, on hyperthreaded systems, this count may be double
that of the available processors. Using hyperthreading does not guarantee
any performance improvement - it may be better to set the number of threads
to half the reported number. \code{parallelly::availableCores()} takes HPC
scheduler/CRAN/Bioconductor limits into account when reporting the number of
available threads but it may not reliably report hyperthreading ('system' or
'nproc'). To set the number of threads without having to call
\code{set_threads()} in every session, put

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(iscream.threads = [n_threads])
}\if{html}{\out{</div>}}

in your \code{.Rprofile} See \code{help('Rprofile')} for information on startup options.

Functions currently using multithreading:
\itemize{
\item \code{tabix()}, \code{tabix_gr()}, \code{tabix_raw()}
\item \code{query_chroms()}
\item \code{make_mat()}, \code{make_mat_se()}, \code{make_mat_gr()}, \code{make_mat_bsseq()}
\item \code{summarize_regions()}, \code{summarize_meth_regions()}
}
}
\examples{
(ncores <- parallelly::availableCores())
\donttest{
set_threads(ncores)
}
}
