% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadVcfTrack}
\alias{loadVcfTrack}
\title{load a VCF (variant) track provided as a Bioconductor 
VariantAnnotation object}
\usage{
loadVcfTrack(session, id, trackName, vcfData, deleteTracksOfSameName = TRUE)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{vcfData}{VariantAnnotation object}

\item{deleteTracksOfSameName}{logical, default TRUE}
}
\value{
nothing
}
\description{
load a VCF (variant) track provided as a Bioconductor 
VariantAnnotation object
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo-withVCF.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
