% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-AbundancePlot.R
\docType{class}
\name{AbundancePlot-class}
\alias{AbundancePlot-class}
\alias{AbundancePlot}
\title{Abundance plot}
\value{
The \code{AbundancePlot(...)} constructor creates an instance of an
AbundancePlot class, where any slot and its value can be passed to \code{...}
as a named argument.
}
\description{
Composite abundance profile of all features in a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}
object. The panel implements \code{\link[miaViz:plotAbundance]{plotAbundance}}
to generate the plot.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualization:
\itemize{
\item \code{rank}, a string specifying the taxonomic rank to visualize.
\item \code{use_relative}, a logical indicating if the relative values should be calculated.
\item \code{add_legend}, a logical indicating if the color legend should appear.
}

In addition, this class inherits all slots from its parent class
\code{\link[iSEE:Panel-class]{Panel}}.
}

\examples{
# Import TreeSE
library(mia)
data("Tengeler2020", package = "mia")
tse <- Tengeler2020

# Store panel into object
panel <- AbundancePlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\author{
Giulio Benedetti
}
