% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEfgseaResults-class.R
\docType{methods}
\name{iSEEfgseaResults-class}
\alias{iSEEfgseaResults-class}
\alias{iSEEfgseaResults}
\alias{embedPathwaysResults,iSEEfgseaResults-method}
\alias{featuresStats,iSEEfgseaResults-method}
\alias{pathwaysList,iSEEfgseaResults-method}
\alias{pathwayType,iSEEfgseaResults-method}
\title{The iSEEfgseaResults class}
\value{
\code{iSEEfgseaResults()} returns an object of class \code{iSEEfgseaResults}.
}
\description{
The \code{iSEEfgseaResults} class is used to provide an common interface to pathway analysis results produced by the \pkg{fgsea} package.
It provides methods to access the set of features in each pathway.
}
\section{Slot overview}{

This class inherits all its slots directly from its parent class \code{iSEEpathwaysResults}.
}

\section{Constructor}{

\code{iSEEfgseaResults(data, pathwayType, pathwaysList = NULL, featuresStats = NULL)} creates an instance of a \code{iSEEfgseaResults} class, with:

\describe{
\item{\code{data}}{A \code{data.frame} produced by \code{fgsea::fgsea()}.}
\item{\code{pathwayType}}{A character scalar specifying the type of pathway (e.g., \code{"GO"}). See \link{embedPathwaysResults}.}
\item{\code{pathwaysList}}{A named list of pathways and associated feature identifiers.}
\item{\code{featuresStats}}{Feature-level statistics used in the pathway analysis.}
}
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \code{iSEEfgseaResults} class.
Refer to the documentation for each method for more details on the remaining arguments.

\itemize{
\item \code{embedPathwaysResults(x, se, name, pathwayType, ...)} embeds \code{x} in se under the identifier \code{name}. See \code{embedPathwaysResults()} for more details.
\item \code{pathwaysList(x)} returns the named list of pathway identifiers and associated
}
}

\examples{
library("fgsea")

##
# Simulate example data
##

simulated_data <- simulateExampleData(n_pathways = 5, n_features = 100, pathway_sizes = 15:100)

pathways_list <- simulated_data$pathwaysList
features_stats <- simulated_data$featuresStat
se <- simulated_data$summarizedexperiment

##
# Run pathway analysis ----
##

set.seed(42)
fgseaRes <- fgsea(pathways = pathways_list,
                  stats    = features_stats,
                  minSize  = 15,
                  maxSize  = 500)
head(fgseaRes[order(pval), ])

##
# iSEEfgseaResults ----
##

# Embed the FGSEA results in the SummarizedExperiment object
se <- embedPathwaysResults(fgseaRes, se, name = "fgsea", class = "fgsea",
  pathwayType = "simulated", pathwaysList = pathways_list, featuresStats = features_stats)
se

##
# Access ----
##

pathwaysResultsNames(se)
pathwaysResults(se)
pathwaysResults(se, "fgsea")

pathwayType(pathwaysResults(se, "fgsea"))
head(lengths(pathwaysList(pathwaysResults(se, "fgsea"))))
head(featuresStats(pathwaysResults(se, "fgsea")))
}
\author{
Kevin Rue-Albrecht
}
