% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEElimma-class.R
\docType{methods}
\name{iSEELimmaResults-class}
\alias{iSEELimmaResults-class}
\alias{iSEELimmaResults}
\alias{showAsCell,iSEELimmaResults-method}
\alias{pValue,iSEELimmaResults-method}
\alias{log2FoldChange,iSEELimmaResults-method}
\alias{averageLog2,iSEELimmaResults-method}
\alias{embedContrastResults,iSEELimmaResults-method}
\title{The iSEELimmaResults class}
\description{
The \code{iSEELimmaResults} class is used to provide a common interface to differential expression results produced by the \pkg{limma} package.
It provides methods to access common differential expression statistics (e.g., log fold-change, p-value, log2 average abundance).
}
\details{
This class inherits all its slots directly from its parent class \linkS4class{DataFrame}.
}
\section{Constructor}{

\code{iSEELimmaResults(data, row.names = rownames(data))} creates an instance of a \code{iSEELimmaResults} class, with:

\describe{
\item{\code{data}}{A \code{data.frame} produced by \code{limma::topTable()}.}
\item{\code{row.names}}{The character vector of rownames for the \linkS4class{SummarizedExperiment} object in which the object is to be embedded. Must be a superset of \code{rownames(data)}.}
}
}

\section{Supported methods}{

\itemize{
\item \code{embedContrastResults(x, se, name, class = "limma", ...)} embeds \code{x} in \code{se} under the identifier \code{name}. See \code{\link[=embedContrastResults]{embedContrastResults()}} for more details.
\item \code{pValue(x)} returns the vector of raw p-values.
\item \code{log2FoldChange(x)} returns the vector of log2-fold-change values.
\item \code{averageLog2(x)} returns the vector of average log2-expression values.
}
}

\examples{
library(limma)
library(SummarizedExperiment)

##
# From limma::lmFit() ----
##

sd <- 0.3 * sqrt(4 / rchisq(100, df = 4))
y <- matrix(rnorm(100 * 6, sd = sd), 100, 6)
rownames(y) <- paste("Gene", 1:100)
y[1:2, 4:6] <- y[1:2, 4:6] + 2
design <- cbind(Grp1 = 1, Grp2vs1 = c(0, 0, 0, 1, 1, 1))

fit <- lmFit(y, design)
fit <- eBayes(fit)
tt <- topTable(fit, coef = 2)
head(tt)

##
# iSEELimmaResults ----
##

# Simulate the original SummarizedExperiment object
se <- SummarizedExperiment(assays = list(counts = y))

# Embed the Limma-Voom results in the SummarizedExperiment object
se <- embedContrastResults(tt, se, name = "Limma-Voom", class = "limma")

##
# Access ----
##

contrastResultsNames(se)
contrastResults(se)
contrastResults(se, "Limma-Voom")

head(pValue(contrastResults(se, "Limma-Voom")))
head(log2FoldChange(contrastResults(se, "Limma-Voom")))
head(averageLog2(contrastResults(se, "Limma-Voom")))
}
\author{
Kevin Rue-Albrecht
}
