% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jitterPoints.R
\name{jitterSquarePoints}
\alias{jitterSquarePoints}
\alias{jitterViolinPoints}
\title{Jitter points for categorical variables}
\usage{
jitterSquarePoints(X, Y, grouping = NULL)

jitterViolinPoints(X, Y, grouping = NULL, ...)
}
\arguments{
\item{X}{A factor corresponding to a categorical variable.}

\item{Y}{A numeric vector of the same length as \code{X} for \code{jitterViolinPoints}, or a factor of the same length as \code{X} for \code{jitterSquarePoints}.}

\item{grouping}{A named list of factors of the same length as \code{X}, specifying how elements should be grouped.}

\item{...}{Further arguments to be passed to \code{\link{offsetX}}.}
}
\value{
For \code{jitterViolinPoints}, a numeric vector is returned containing the jittered x-axis coordinates for all points.

For \code{jitterSquarePoints}, a list is returned with numeric vectors \code{X} and \code{Y}, containing jittered coordinates on the x- and y-axes respectively for all points;
and \code{summary}, a data.frame of frequencies and side lengths for each unique pairing of X/Y levels.
}
\description{
Add quasi-random jitter on the x-axis for violin plots when the x-axis variable is categorical.
Add random jitter within a rectangular area for square plots when both x- and y-axis variables are categorical.
}
\details{
The \code{jitterViolinPoints} function calls \code{\link{offsetX}} to obtain quasi-random jittered x-axis values.
This reflects the area occupied by a violin plot, though some tuning of arguments in \code{...} may be required to get an exact match.

The \code{jitterSquarePoints} function will uniformly jitter points on both the x- and y-axes. 
The jitter area is a square with area proportional to the frequency of the paired levels in \code{X} and \code{Y}.
If either factor only has one level, the jitter area becomes a rectangle that can be interpreted as a bar plot.

If \code{grouping} is specified, the values corresponding to each point defines a single combination of levels.
Both functions will then perform jittering separately within each unique combination of levels.
This is useful for obtaining appropriate jittering when points are split by group, e.g., during faceting.

If \code{grouping!=NULL} for \code{jitterSquarePoints} the statistics in the returned \code{summary} data.frame will be stratified by unique combinations of levels.
To avoid clashes with existing fields, the names in \code{grouping} should not be \code{"X"}, \code{"Y"}, \code{"Freq"}, \code{"XWidth"} or \code{"YWidth"}.
}
\examples{
X <- factor(sample(LETTERS[1:4], 100, replace=TRUE))
Y <- rnorm(100)
(out1 <- jitterViolinPoints(X=X, Y=Y))

Y2 <- factor(sample(letters[1:3], 100, replace=TRUE))
(out2 <- jitterSquarePoints(X=X, Y=Y2))

grouped <- sample(5, 100, replace=TRUE)
(out3 <- jitterViolinPoints(X=X, Y=Y, grouping=list(FacetRow=grouped)))
(out4 <- jitterSquarePoints(X=X, Y=Y2, grouping=list(FacetRow=grouped)))
}
\author{
Aaron Lun
}
