% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observers_param.R
\name{.createUnprotectedParameterObservers}
\alias{.createUnprotectedParameterObservers}
\alias{.createProtectedParameterObservers}
\title{Define parameter observers}
\usage{
.createUnprotectedParameterObservers(
  panel_name,
  fields,
  input,
  pObjects,
  rObjects,
  ignoreInit = TRUE,
  ignoreNULL = TRUE
)

.createProtectedParameterObservers(
  panel_name,
  fields,
  input,
  pObjects,
  rObjects,
  ignoreInit = TRUE,
  ignoreNULL = TRUE
)
}
\arguments{
\item{panel_name}{String containing the name of the panel.}

\item{fields}{Character vector of names of parameters for which to set up observers.}

\item{input}{The Shiny input object from the server function.}

\item{pObjects}{An environment containing global parameters generated in the \code{\link{iSEE}} app.}

\item{rObjects}{A reactive list of values generated in the \code{\link{iSEE}} app.}

\item{ignoreInit, ignoreNULL}{Further arguments to pass to \code{\link{observeEvent}}.}
}
\value{
Observers are set up to monitor the UI elements that can change the protected and non-fundamental parameters.
A \code{NULL} is invisibly returned.
}
\description{
Define a series of observers to track \dQuote{protected} or \dQuote{unprotected} parameters for a given panel.
These will register input changes to each specified parameter in the app's memory
and request an update to the output of the affected panel.
}
\details{
A protected parameter is one that breaks existing multiple selections, e.g., by changing the actual data being plotted.
Alterations to protected parameters will clear all active and saved selections in the panel,
as those existing selections are assumed to not make any sense in the context of the modified output of that panel.

By comparison, an unprotected parameter only changes the aesthetics and will not clear existing selections.
}
\seealso{
\code{\link{.requestUpdate}} and \code{\link{.requestCleanUpdate}},
used to trigger updates to the panel output.
}
\author{
Aaron Lun
}
