% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family_RowDotPlot.R
\docType{methods}
\name{RowDotPlot-class}
\alias{RowDotPlot-class}
\alias{initialize,RowDotPlot-method}
\alias{.cacheCommonInfo,RowDotPlot-method}
\alias{.refineParameters,RowDotPlot-method}
\alias{.defineInterface,RowDotPlot-method}
\alias{.createObservers,RowDotPlot-method}
\alias{.getTooltipUI,RowDotPlot-method}
\alias{.hideInterface,RowDotPlot-method}
\alias{.multiSelectionDimension,RowDotPlot-method}
\alias{.multiSelectionResponsive,RowDotPlot-method}
\alias{.multiSelectionRestricted,RowDotPlot-method}
\alias{.multiSelectionInvalidated,RowDotPlot-method}
\alias{.singleSelectionDimension,RowDotPlot-method}
\alias{.definePanelTour,RowDotPlot-method}
\alias{.getDotPlotColorHelp,RowDotPlot-method}
\alias{[[,RowDotPlot-method}
\alias{[[,RowDotPlot,ANY,ANY-method}
\alias{[[<-,RowDotPlot-method}
\alias{[[<-,RowDotPlot,ANY,ANY-method}
\alias{updateObject,RowDotPlot-method}
\title{The RowDotPlot virtual class}
\description{
The RowDotPlot is a virtual class where each row in the \linkS4class{SummarizedExperiment} is represented by no more than one point (i.e., a \dQuote{dot}) in a brushable \link{ggplot} plot.
It provides slots and methods to extract \code{\link{rowData}} fields to control the per-point aesthetics on the plot.
This panel will transmit row identities in both its single and multiple selections, and it can receive multiple row selections but not multiple column selections.
}
\section{Slot overview}{

The following slots control coloring of the points:
\itemize{
\item \code{ColorByRowData}, a string specifying the \code{\link{rowData}} field for controlling point color,
if \code{ColorBy="Row data"} (see the \linkS4class{Panel} class).
Defaults to the first valid field (see \code{.cacheCommonInfo} below).
\item \code{ColorBySampleNameAssay}, a string specifying the assay of the SummarizedExperiment object containing values to use for coloring,
if \code{ColorBy="Sample name"}.
Defaults to \code{"logcounts"} in \code{\link{getPanelDefault}}, falling back to the name of the first valid assay
(see \code{?"\link{.cacheCommonInfo,DotPlot-method}"} for the definition of validity).
\item \code{ColorByFeatureNameColor}, a string specifying the color to use for coloring an individual sample on the plot,
if \code{ColorBy="Feature name"}.
Defaults to \code{"red"} in \code{\link{getPanelDefault}}.
}

The following slots control other metadata-related aesthetic aspects of the points:
\itemize{
\item \code{ShapeByRowData}, a string specifying the \code{\link{rowData}} field for controlling point shape,
if \code{ShapeBy="Row data"} (see the \linkS4class{Panel} class).
The specified field should contain categorical values; defaults to the first such field.
\item \code{SizeByRowData}, a string specifying the \code{\link{rowData}} field for controlling point size,
if \code{SizeBy="Row data"} (see the \linkS4class{Panel} class).
The specified field should contain continuous values; defaults to the first such field.
\item \code{TooltipRowData}, a character vector specifying \code{\link{rowData}} fields to show in the tooltip.
Defaults to `character(0)`, which displays only the `rownames` value of the data point.
}

In addition, this class inherits all slots from its parent \linkS4class{DotPlot} and \linkS4class{Panel} classes.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{RowDotPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.cacheCommonInfo}(x)} adds a \code{"RowDotPlot"} entry containing \code{valid.rowData.names}, a character vector of valid column data names (i.e., containing atomic values); \code{discrete.rowData.names}, a character vector of names for discrete columns; and \code{continuous.rowData.names}, a character vector of names of continuous columns.
This will also call the equivalent \linkS4class{DotPlot} method.
\item \code{\link{.refineParameters}(x, se)} replaces \code{NA} values in \code{ColorByFeatAssay} with the first valid assay name in \code{se}.
This will also call the equivalent \linkS4class{DotPlot} method.
}

For defining the interface:
\itemize{
\item \code{\link{.hideInterface}(x, field)} returns a logical scalar indicating whether the interface element corresponding to \code{field} should be hidden.
This returns \code{TRUE} for row selection parameters (\code{"RowSelectionSource"} and \code{"RowSelectionRestrict"}),
otherwise it dispatches to the \linkS4class{Panel} method.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all slots in the \linkS4class{RowDotPlot}.
This will also call the equivalent \linkS4class{DotPlot} method.
}

For controlling selections:
\itemize{
\item \code{\link{.multiSelectionRestricted}(x)} returns a logical scalar indicating whether \code{x} is restricting the plotted points to those that were selected in a transmitting panel.
\item \code{\link{.multiSelectionDimension}(x)} returns \code{"row"} to indicate that a multiple row selection is being transmitted.
\item \code{\link{.multiSelectionInvalidated}(x)} returns \code{TRUE} if the faceting options use the multiple row selections,
such that the point coordinates/domain may change upon updates to upstream selections in transmitting panels.
\item \code{\link{.singleSelectionDimension}(x)} returns \code{"feature"} to indicate that a feature identity is being transmitted.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a tour relevant to subclasses,
mostly tuning the more generic descriptions from the same method of the parent \linkS4class{DotPlot}.
\item \code{\link{.getDotPlotColorHelp}(x, color_choices)} returns a data.frame containing the documentation for the \code{"ColorBy"} UI element,
specialized for row-based dot plots.
}

Unless explicitly specialized above, all methods from the parent classes \linkS4class{DotPlot} and \linkS4class{Panel} are also available.
}

\section{Subclass expectations}{

Subclasses are expected to implement methods for, at least:
\itemize{
\item \code{\link{.generateDotPlotData}}
\item \code{\link{.fullName}}
\item \code{\link{.panelColor}}
}

The method for \code{\link{.generateDotPlotData}} should create a \code{plot.data} data.frame with one row per row in the \linkS4class{SummarizedExperiment} object.
}

\seealso{
\linkS4class{DotPlot}, for the immediate parent class that contains the actual slot definitions.
}
\author{
Aaron Lun
}
