% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctEigengenes.R
\name{fctEigengenes}
\alias{fctEigengenes}
\title{fctEigengenes}
\usage{
fctEigengenes(loadData = loadData, clusterAssignments = clusterAssignments)
}
\arguments{
\item{loadData}{A prepossessed data matrix resulting from "load data" function}

\item{clusterAssignments}{A vector of cluster assignments for each feature.}
}
\value{
A list containing:
\item{module_eigenmetab_List_Me}{The full result from WGCNA::moduleEigengenes.}
\item{module_eigenmetab_Me}{The matrix of module eigengenes.}
\item{feature_mat_t}{The filtered and scaled feature matrix.}
}
\description{
Calculates module eigengenes using the WGCNA package.
}
\examples{
# Simulate a small expression matrix
set.seed(123)
mat <- matrix(rnorm(100), nrow = 10, ncol = 10)
colnames(mat) <- paste0("Gene", 1:10)
rownames(mat) <- paste0("Sample", 1:10)

# Simulate cluster assignments
clusters <- rep(1:2, each = 5)

# Run Eigengenes function
result <- fctEigengenes(loadData = mat, clusterAssignments = clusters)

# View eigengene matrix
head(result$module_eigenmetab_Me)

}
