% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R
\docType{methods}
\name{stratiflevels}
\alias{stratiflevels}
\alias{stratiflevels,COBRAPerformance-method}
\alias{stratiflevels,COBRAPlot-method}
\title{Accessor function for stratification levels}
\usage{
stratiflevels(x, ...)

\S4method{stratiflevels}{COBRAPerformance}(x)
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object}

\item{...}{Additional arguments}
}
\value{
A character vector of all stratification levels represented in the
  object
}
\description{
Accessor function to extract the stratification levels that are represented
in a \code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtpr", splv = "expr_cat",
                                   maxsplit = 4)
stratiflevels(cobraperf)
}
\author{
Charlotte Soneson
}
