% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{splv}
\alias{splv}
\alias{splv<-}
\alias{splv,COBRAPerformance-method}
\alias{splv<-,COBRAPerformance,character-method}
\alias{splv,COBRAPlot-method}
\alias{splv<-,COBRAPlot,character-method}
\title{Accessor and replacement functions for \code{splv} slot}
\usage{
splv(x, ...)

splv(x, ...) <- value

\S4method{splv}{COBRAPerformance}(x)

\S4method{splv}{COBRAPerformance,character}(x) <- value

\S4method{splv}{COBRAPlot,character}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A character string giving the name of a feature annotation to
use for stratification.}
}
\value{
The accessor function returns a character string giving the name of a
  feature annotation to use for stratification.
}
\description{
Accessor and replacement functions for the \code{splv} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtpr", splv = "expr_cat")
splv(cobraperf)
}
\author{
Charlotte Soneson
}
