% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPlot.R
\docType{methods}
\name{plotcolors}
\alias{plotcolors}
\alias{plotcolors<-}
\alias{plotcolors,COBRAPlot-method}
\alias{plotcolors<-,COBRAPlot,character-method}
\title{Accessor and replacement functions for \code{plotcolors} slot}
\usage{
plotcolors(x, ...)

plotcolors(x, ...) <- value

\S4method{plotcolors}{COBRAPlot}(x)

\S4method{plotcolors}{COBRAPlot,character}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A character vector giving the colors assigned to each of the
methods (or method/stratification level combinations) represented in the
\code{COBRAPlot} object.}
}
\value{
The accessor function returns a character vector giving the colors
  assigned to each of the methods (or method/stratification level
  combinations) represented in the \code{COBRAPlot} object.
}
\description{
Accessor and replacement functions for the \code{plotcolors} slot in an
\code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtpr")
cobraplot <- prepare_data_for_plot(cobraperf)
plotcolors(cobraplot)
}
\author{
Charlotte Soneson
}
