% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{corr}
\alias{corr}
\alias{corr<-}
\alias{corr,COBRAPerformance-method}
\alias{corr<-,COBRAPerformance,data.frame-method}
\alias{corr<-,COBRAPlot,data.frame-method}
\alias{corr,COBRAPlot-method}
\title{Accessor and replacement functions for \code{corr} slot}
\usage{
corr(x, ...)

corr(x, ...) <- value

\S4method{corr}{COBRAPerformance}(x)

\S4method{corr}{COBRAPerformance,data.frame}(x) <- value

\S4method{corr}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving correlation values for each method and each
stratification level.}
}
\value{
The accessor function returns a data frame giving correlation values
  for each method and each stratification level.
}
\description{
Accessor and replacement functions for the \code{corr} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example, cont_truth = "logFC",
                                   aspects = "corr")
head(corr(cobraperf))
}
\author{
Charlotte Soneson
}
