% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COBRAPerformance.R
\docType{class}
\name{COBRAPerformance-class}
\alias{COBRAPerformance-class}
\alias{.COBRAPerformance}
\alias{COBRAPerformance}
\title{\code{COBRAPerformance} object and constructor}
\usage{
COBRAPerformance(
  fdrtpr = data.frame(),
  fdrtprcurve = data.frame(),
  fdrnbr = data.frame(),
  fdrnbrcurve = data.frame(),
  fsrnbr = data.frame(),
  fsrnbrcurve = data.frame(),
  tpr = data.frame(),
  fpr = data.frame(),
  splv = "",
  roc = data.frame(),
  fpc = data.frame(),
  deviation = data.frame(),
  onlyshared = NA,
  overlap = data.frame(),
  maxsplit = NA_integer_,
  corr = data.frame(),
  scatter = data.frame()
)
}
\arguments{
\item{fdrtpr}{A data frame containing observed FDR and TPR values at various
adjusted p-value thresholds.}

\item{fdrtprcurve}{A data frame containing observed FDR and TPR values for a
(potentially large) number of cutoffs applied to a 'score' (that can be
p-value, adjusted p-value or a more general score).}

\item{fdrnbr}{A data frame containing observed FDR and the number of features
considered to be significant at various adjusted p-value thresholds.}

\item{fdrnbrcurve}{A data frame containing observed FDR and number of
features considered to be significant for a (potentially large) number of
cutoffs applied to a 'score' (that can be p-value, adjusted p-value or a
more general score).}

\item{fsrnbr}{A data frame containing observed false sign rate (FSR) and the
number of features considered to be significant at various s-value
thresholds}

\item{fsrnbrcurve}{A data frame containing observed false sign rate (FSR) and
number of features considered to be significant for a (potentially large)
number of cutoffs applied to the s-value}

\item{tpr}{A data frame containing observed TPR values at various adjusted
p-value thresholds.}

\item{fpr}{A data frame containing observed FPR values at various adjusted
p-value thresholds.}

\item{splv}{A character string giving the name of the stratification factor,
"none" if the results are not stratified.}

\item{roc}{A data frame containing observed FPR and TPR values  for a
(potentially large) number of cutoffs applied to a 'score' (that can be
p-value, adjusted p-value or a more general score), which can be used to
generate a ROC curve.}

\item{fpc}{A data frame containing observed numbers of false positive
findings among the N top-ranked features (ranked by p-values, adjusted
p-values or more general scores), for a (potentially large) number of Ns,
which can be used to generate a false positive curve.}

\item{deviation}{A data frame containing deviations between observed scores
and true scores.}

\item{onlyshared}{A logical value indicating whether only features shared
between the results and the truth should be retained, or if all features
present in the truth should be used.}

\item{overlap}{A data frame or list of data frames with binary values
indicating, for each of a number of methods and number of features, whether
the method consider the feature 'positive' (significant, 1) or 'negative'
(non-significant, 0). If it is a list of data frames, each list element
corresponds to one level of a stratifying factor.}

\item{maxsplit}{A numeric value indicating the largest number of levels to
retain if the results have been stratified by an annotation.}

\item{corr}{A data frame containing observed (Pearson and Spearman)
correlation values between observed and true scores.}

\item{scatter}{A data frame containing observed 'scores' (p-values, adjusted
p-values or more general scores) and true scores, which can be used to
generate scatter plots.}
}
\value{
A \code{COBRAPerformance} object.
}
\description{
The \code{COBRAPerformance} class holds various types of calculated
performance measures. Objects from this class are typically generated from
\code{COBRAData} objects by means of the function
\code{\link{calculate_performance}}.
}
\examples{
## Empty COBRAPerformance object
COBRAPerformance()
}
\author{
Charlotte Soneson
}
