% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotindi_function.R
\name{plotindi}
\alias{plotindi}
\title{Individual sample plot}
\usage{
plotindi(ngs_plr, snp_lrr, ngs_baf, snp_baf, ngs_plr.pos, snp_lrr.pos,
  ngs_baf.pos, snp_baf.pos, icnvres, I = numeric(), h = NULL, t = NULL)
}
\arguments{
\item{ngs_plr}{A list of NGS intensity data. Each entry is an individual. If no NGS data, no need to specify.}

\item{snp_lrr}{A list of SNP array intensity data. Each entry is an individual. If no SNP array data, no need to specify.}

\item{ngs_baf}{A list of NGS BAF data. Each entry is an individual. If no NGS data, no need to specify.}

\item{snp_baf}{A list of SNP array BAF data. Each entry is an individual. If no SNP array data, no need to specify.}

\item{ngs_plr.pos}{A list of NGS intensity postion data. Each entry is an individual with dimension= (#of bins or exons, 2(start and end position)). If no NGS data, no need to specify.}

\item{snp_lrr.pos}{A list of SNP array intensity postion data. Each entry is an individual with length=#of SNPs. If no SNP array data, no need to specify.}

\item{ngs_baf.pos}{A list of NGS BAF postion data. Each entry is an individual with length=#of BAFs. If no NGS data, no need to specify.}

\item{snp_baf.pos}{A list of SNP array BAF postion data. Each entry is an individual with length=#of BAFs. If no SNP array data, no need to specify.}

\item{icnvres}{CNV inference result. The output from iCNV_detection()}

\item{I}{Indicating the position of the individual to plot. Type integer.}

\item{h}{start position of this plot. Default Start of the whole chromosome}

\item{t}{end position of this plot. Default End of the whole chromosome}
}
\value{
void
}
\description{
Plot relationship between platforms and features for each individual. 
Only work for muli-platform inference.
}
\examples{
plotindi(ngs_plr,snp_lrr,ngs_baf,snp_baf,
 ngs_plr.pos,snp_lrr.pos,ngs_baf.pos,snp_baf.pos,
 icnv_res0,I=1)
}
