% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_msig.R
\name{msigdb_gsets}
\alias{msigdb_gsets}
\title{Download data from msigdb in the form of a gsets object}
\usage{
msigdb_gsets(species, collection, subcollection = NULL, clean = FALSE)
}
\arguments{
\item{species}{A species to determine gene symbols (refer to ?msigdbr::msigdbr_species for available species)}

\item{collection}{Geneset collection (refer to ?msigdbr::msigdbr_collections for available categories)}

\item{subcollection}{Geneset subcollection (refer to ?msigdbr::msigdbr_collections for available subcategories)}

\item{clean}{Use true to clean labels of genesets}
}
\value{
A gsets object
}
\description{
Download data from msigdb in the form of a gsets object
}
\examples{
HALLMARK_HUMAN <- msigdb_gsets("Homo sapiens", "H")
HALLMARK_MOUSE <- msigdb_gsets("Mus musculus", "MH")

}
