##' @title Human Protein Atlas in R
##'
##' @description
##'
##' This package provides a simple interface to the Human Protein
##' Atlas. From the Human Protein Atlas Project page: The Swedish
##' Human Protein Atlas project, funded by the Knut and Alice
##' Wallenberg Foundation, has been set up to allow for a systematic
##' exploration of the human proteome using Antibody-Based
##' Proteomics. This is accomplished by combining high-throughput
##' generation of affinity-purified antibodies with protein profiling
##' in a multitude of tissues and cells assembled in tissue
##' microarrays. Confocal microscopy analysis using human cell lines
##' is performed for more detailed protein localization. The program
##' hosts the Human Protein Atlas portal with expression profiles of
##' human proteins in tissues and cells.
##'
##' See the vignette for available data.
##'
##' @aliases hpar hpaCancer16.1 hpaCancer hpaNormalTissue16.1 hpaNormalTissue hpaSecretome hpaSubcellularLoc14 hpaSubcellularLoc16.1 hpaSubcellularLoc rnaConsensusTissue rnaFantomTissue rnaGeneCellLine16.1 rnaGeneCellLine rnaGeneTissue21.0 rnaGtexTissue rnaHpaTissue
##'
##' @section HPA data usage policy:
##'
##' The use of data and images from the HPA site in publications and
##' presentations is permitted provided that the following conditions
##' are met:
##'
##' - The publication and/or presentation are solely for informational
##'   and non-commercial purposes.
##'
##' - The source of the data and/or image is referred to this site
##'   (www.proteinatlas.org) and/or one or more of our publications
##'   are cited.
##'
##' @seealso
##'
##' The package vignette can be accessed with `vignette("hpar")`.
##'
##' @section References:
##'
##' - See the Human Protein Atlas Project page
##'   <http://www.proteinatlas.org> and
##'   <http://www.proteinatlas.org/about/download> for more details
##'   and documentation.
##'
##' - Uhlen et al (2015). Tissue-based map of the human
##'   proteome. Science. 347(6220):1260419.
##'
##' - Uhlen et al (2010). Towards a knowledge-based Human Protein
##'   Atlas. Nat Biotechnol. 28(12):1248-50.
##'
##' - Berglund et al (2008). A gene-centric Human Protein Atlas for
##'   expression profiles based on antibodies. Mol Cell
##'   Proteomics. 7(10):2019-27.
##'
##' - Uhlen et al (2005). A human protein atlas for normal and cancer
##'   tissues based on antibody proteomics. Mol Cell
##'   Proteomics. 4(12):1920-1932.
##'
##' - Ponten et al (2008). The Human Protein Atlas - a tool for
##'   pathology. J Pathology. 216(4):387-93.
##'
##' @keywords internal
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
